<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:include href="ffcpl:/main/forum/common/lib.xsl"/>
	<xsl:template match="/">
		<div title="Entry - {results/row/title}">
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	
	<xsl:template match="null">
		<div>No Entry</div>
	</xsl:template>
	
	<xsl:template match="results">
		<div>
			<table>
				
				<xsl:apply-templates select="row"/>
			</table>
		</div>
	</xsl:template>
	<xsl:template match="row">
		<tr>
		<td class="nav-links" colspan="2">
			<!--<xsl:copy-of select="$meta/meta/info/results/row"/>-->
			<a href="xrl:index" xrl:resolve="href">Forum</a>
			-> <a href="[[xrl:topic-index]]{forumid}" xrl:resolve="href"><xsl:value-of select="fname"/></a>
			-> <a href="[[xrl:topic]]{topicid}" xrl:resolve="href"><xsl:value-of select="ttitle"/></a> -> <xsl:value-of select="title"/>
		</td>
		</tr>
		<tr class="group-block">
			<td class="forum-title" colspan="2">
				<img align="middle" src="xrl:img_topic" xrl:resolve="src"/>
				<xsl:value-of select="title"/>
			</td>
		</tr>
		<tr>
			<td style="vertical-align: top;" width="25%">
				<xrl:include href="xrl:user-meta-widget">
					<nvp>
						<id><xsl:value-of select="author"/></id>
					</nvp>
				</xrl:include>
			</td>
			<td width="75%" style="vertical-align: top;" class="entry-content">
				<div><span  class="forum-date">Posted:
					<xsl:value-of select="edateDayOfMonth"/>-<xsl:value-of select="edateMonthName"/>-<xsl:value-of select="edateYear"/>
					<xsl:text> </xsl:text>
					<xsl:call-template name="addzero"><xsl:with-param name="n" select="etimeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="etimeMinute"/></xsl:call-template>
				</span></div>
				<xsl:copy-of select="entry/*"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet> 
