<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="errors"/>
	<xsl:template match="/nvp">
		<div title="Sign Up for 1060 Forum" desc="Please complete this form to sign up for free membership" class="content">
		<script language="javascript" type="text/javascript">
		<xsl:comment>
			function init()
			{	joinform.userid.focus();
			}
		</xsl:comment>
		</script>
			<form name="joinform" action="" xrl:resolve="action" method="POST">
				<table cellpadding="2" cellspacing="0" style="background: url([[xrl:img-flat]]); padding-bottom: 4px;" xrl:resolve="style">
					<tr><td colspan="2" class="group-header">Sign Up for 1060 Forum</td></tr>
					<tr><td colspan="2" class="tiny">Fields marked with an asterisk * are required.
					</td></tr>
					<tr>
						<td class="label">User ID:<sup>*</sup></td>
						<td><input title="Your prefered user id - this will be displayed along side your posts" name="userid" value="{userid}"/></td>
						<xsl:if test="$errors/b/error[@userid]">
								<td>
									<div style="border: 1px solid red; padding: 3px;">
										<xsl:for-each select="$errors/b/error[@userid]">
											<xsl:value-of select="."/><br/>
										</xsl:for-each>
									</div>
								</td>
						</xsl:if>
					</tr>

					<tr>
						<td class="label">Email:<sup>*</sup></td>
						<td><input size="50" title="This address will receive instructions to complete registration" name="email" value="{email}"/></td>
						<xsl:if test="$errors/b/error[@email]">
								<td>
									<div style="border: 1px solid red; padding: 3px;">
										<xsl:for-each select="$errors/b/error[@email]">
											<xsl:value-of select="."/><br/>
										</xsl:for-each>
									</div>
								</td>
						</xsl:if>
					</tr>
					<tr>
						<td class="label">Web:</td><td><input size="50" title="Please provide a full URL eg http://www.1060.org" name="web" value="{web}"/></td>
					</tr>
					<tr>
						<td class="label">Image URL:</td><td><input size="50" title="The URL of a 60x60 px image of you eg http://www.1060.org/pjr.png" name="imageurl" value="{imageurl}"/></td>
					</tr>
					<tr>
						<td class="label">Location</td><td><input size="40" title="Your physical location" name="location" value="{location}"/></td>
					</tr>
					<tr>
						<td class="label">Biography:</td><td><textarea title="A brief plain text biography of yourself" style="width: 400px; height 150px;" name="biog"><xsl:value-of select="biog"/></textarea></td>
					</tr>
					<tr>
						<td class="label">Password:<sup>*</sup></td><td><input type="password" name="password" value="{password}"/></td>
						<xsl:if test="$errors/b/error[@password]">
								<td>
									<div style="border: 1px solid red; padding: 3px;">
										<xsl:for-each select="$errors/b/error[@password]">
											<xsl:value-of select="."/><br/>
										</xsl:for-each>
									</div>
								</td>
						</xsl:if>
					</tr>
					<tr>
						<td class="label">Password (Repeat):<sup>*</sup></td><td><input type="password" name="password2" value="{password2}"/></td>
					</tr>
					<tr>
						<td class="label">Password Reminder Question:</td><td><input size="50" title="A question we will ask you should you forget your password" name="reminder" value="What is the name of your first school?"/></td>
					</tr>
					<tr>
						<td class="label">Password Reminder Answer:</td><td><input size="40" title="The answer that will prove you are you!" name="answer" value="{answer}"/></td>
					</tr>
					<tr class="titlebar"><td/><td style="text-align: right;">
						<input name="submit" value="Sign Up" type="submit"/>
					</td></tr>
				</table>
			</form>
			<p class="tiny">
			NOTICE: We collect personal information on this page.<br/>
			To learn more about how we use your information, see our <a href="http://www.1060.org/privacy.html">Privacy Policy</a>.
			</p>
		</div>
	</xsl:template>
</xsl:stylesheet> 
