<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:include href="ffcpl:/main/forum/common/lib.xsl"/>
	<xsl:key name="forums" match="row" use="gid"/>
	<xsl:template match="/null">
		<div>No Forums Set Up</div>
	</xsl:template>
	<xsl:template match="/results">
		<div desc="Dulci et profundus est percipio Netkernel">
		<div class="titlebar" style="padding: 2px; margin-bottom: 2;"><a href="search/1/1"><span class="aa">&#160;</span><span class="bb">view recent entries</span><span class="cc">&#160;</span></a></div>
		<table class="forum-toc" width="100%">
				<xsl:for-each select="row[count(. | key('forums', gid)[1]) = 1]">
					<xsl:variable name="tid" select="id"/>
					<xsl:if test="string-length(key('forums',gid)[id=$tid]/name) &gt; 0">
						<!--Only display groups containing forums-->
						<tr>
							<td colspan="4" class="group-block" style="background: url([[xrl:img-flat]])" xrl:resolve="style">
								<div class="group-title"><xsl:value-of select="groupname"/></div>
								<div class="group-desc"><xsl:value-of select="groupdescr"/></div>
							</td>
						</tr>
						<tr class="group-header">
							<td>forum</td>
							<td class="forum-stat">topics</td>
							<td class="forum-stat">posts</td>
							<td>last post</td>
						</tr>

						<xsl:for-each select="key('forums',gid)">
							<tr>
								<xsl:variable name="tempid" select="id"/>
								<xsl:variable name="ref" select="$param/results/row[forumid=$tempid]"/>
								<td>
									<table class="inner">
										<tr><td>
											<xsl:choose>
												<xsl:when test="string-length(imageurl)">
													<img src="{imageurl}"/>
												</xsl:when>
												<xsl:otherwise>
													<img src="xrl:img_forum" xrl:resolve="src"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<div class="forum-title"><a href="[[xrl:topic-index]]{id}" xrl:resolve="href"><xsl:value-of select="name"/></a></div>
											<div class="forum-desc"><xsl:value-of select="descr"/></div>
										</td>
									</tr></table>
								</td>
								<td class="forum-stat">
									<xsl:value-of select="$ref/topics"/>
								</td>
								<td class="forum-stat">
									<xsl:value-of select="$ref/entries"/>
								</td>
								<td class="forum-last-post">
									<xsl:value-of select="$ref/title"/>
									by <xsl:value-of select="$ref/userid"/> at
	<xsl:call-template name="addzero"><xsl:with-param name="n" select="$ref/timeHour"/></xsl:call-template>:<xsl:call-template name="addzero"><xsl:with-param name="n" select="$ref/timeMinute"/></xsl:call-template><br/>
	<xsl:value-of select="$ref/dateDayOfMonth"/>-<xsl:value-of select="$ref/dateMonthName"/>-<xsl:value-of select="$ref/dateYear"/>
								</td>

							</tr>
						</xsl:for-each>
						<tr><td style="border: none; height: 8px;" colspan="4"> </td></tr>
					</xsl:if>
				</xsl:for-each>
		</table>
		<table width="100%"><tr>
			<td width="100%" valign="middle" style="text-align: right" class="tiny">To find out about all new postings as they occur<br/>please subscribe to one of these feeds:</td>
			<td width="0%" valign="middle">
				<a href="[[xrl:atom-forum-recent-entries]]1" xrl:resolve="href" style="margin-right: 5px;"><img src="xrl:img_atom" xrl:resolve="src" alt="Atom" /></a>
				<a href="[[xrl:rss-forum-recent-entries]]1" xrl:resolve="href"><img src="xrl:img_rss" xrl:resolve="src" alt="RSS" /></a>
			</td>
		</tr></table>
		</div>
	</xsl:template>
	<xsl:template match="row">

	</xsl:template>
</xsl:stylesheet> 
