<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="param"/>
	<xsl:include href="ffcpl:/xlib/styles/format_exception.xsl"/>	

	<xsl:template match="/">
		<xsl:variable name="deepest" select="/descendant::ex[count(/descendant::ex)]"/>
		<xsl:variable name="id" select="$deepest/id"/>
		<xsl:variable name="message" select="$deepest/message"/>
		<div title="Error occured processing request" desc="We are sorry that your request cannot currently be processed">
			<script language="JavaScript">
			<xsl:comment>
			function showException()
			{	if (document.getElementById( 'exception' ).style.display=="none")
				{	document.getElementById( 'exception' ).style.display= "";
					scrollTo(0,65535);
				}
				else
				{	document.getElementById( 'exception' ).style.display= "none";
				}
			}
			</xsl:comment>
		</script>			
			<table border="0" cellspacing="0" cellpadding="4">
			<tr>
			<td valign="middle"><img src="/xlib/img/warning-small.png"/></td>
			<td>
				Please consider the following options:
				<ul>
					<li>If you typed the URL yourself, please make sure that the spelling is correct.</li>
					<li>If you clicked on a link to get here, there may be a problem with the link.</li>
					<li>Try going to the <a href="xrl:index" xrl:resolve="href">forum index</a> to find what you are looking for 
					or alternatively use the <a href="xrl:search-new" xrl:resolve="href">search page</a>.</li>
					<li>If you think is a problem with this page please report <a href="javascript:showException()">this error</a> to forum[AT]1060.org</li>
				</ul>
			</td>
			</tr></table>
		
			<div id="exception" style="margin-left: 40px; width:75%; display: none; background-color:black; padding:2">
				<table border="0" cellspacing="0">
					<tr><td bgcolor="black" colspan="2">
						<font color="white"><b>Detailed Exception Trace</b></font>
					</td></tr>
					<xsl:apply-templates select="ex"/>
				</table>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet> 
