/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ui;

import java.awt.Component;
import java.awt.Graphics;
import org.bluray.ui.AnimationParameters;
import org.bluray.ui.FrameAccurateAnimationTimer;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public abstract class FrameAccurateAnimation
extends Component {
    private Object lock = new Object();
    private BDJXletContext context;
    protected boolean running;
    protected AnimationParameters params;
    public static final float FRAME_RATE_23_976 = 23.976f;
    public static final float FRAME_RATE_24 = 24.0f;
    public static final float FRAME_RATE_25 = 25.0f;
    public static final float FRAME_RATE_29_97 = 29.97f;
    public static final float FRAME_RATE_50 = 50.0f;
    public static final float FRAME_RATE_59_94 = 59.94f;
    private static final long serialVersionUID = 76982966057159330L;
    private static float defaultRate = 25.0f;
    private static final Logger logger = Logger.getLogger(FrameAccurateAnimation.class.getName());

    public static final float getDefaultFrameRate() {
        return defaultRate;
    }

    public static boolean setDefaultFrameRate(float framerate) {
        if (framerate != 23.976f && framerate != 24.0f && framerate != 25.0f && framerate != 29.97f && framerate != 50.0f && framerate != 59.94f) {
            return false;
        }
        defaultRate = framerate;
        return true;
    }

    public FrameAccurateAnimation() {
        logger.unimplemented("FrameAccurateAnimation");
    }

    public FrameAccurateAnimation(AnimationParameters params) {
        this.context = BDJXletContext.getCurrentContext();
        if (this.context != null) {
            this.context.addFAA(this);
        } else {
            logger.error("FrameAccurateAnimation created from wrong thread: " + Logger.dumpStack());
        }
        this.params = new AnimationParameters(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.context != null) {
                this.context.removeFAA(this);
                this.context = null;
            }
            this.destroyImpl();
        }
    }

    public long getCompletedFrameCount() {
        logger.unimplemented("getCompletedFrameCount");
        return 0L;
    }

    public float getFrameRate() {
        logger.unimplemented("getFrameRate");
        return FrameAccurateAnimation.getDefaultFrameRate();
    }

    @Override
    public Graphics getGraphics() {
        logger.unimplemented("getGraphics");
        return super.getGraphics();
    }

    public int[] getRepeatCounts() {
        int[] repeatCount = null;
        if (this.params != null && this.params.repeatCount != null) {
            repeatCount = (int[])this.params.repeatCount.clone();
        }
        return repeatCount;
    }

    public int getThreadPriority() {
        return this.params.threadPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnimated() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    @Override
    public void paint(Graphics g) {
        logger.unimplemented("paint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStartStopTime(FrameAccurateAnimationTimer newTimer) {
        Object object = this.lock;
        synchronized (object) {
            this.params.faaTimer = new FrameAccurateAnimationTimer(newTimer);
            logger.unimplemented("resetStartStopTime");
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void setThreadPriority(int p) {
        this.params.threadPriority = p;
    }

    protected void startImpl() {
        logger.unimplemented("startImpl");
    }

    protected void stopImpl() {
        logger.unimplemented("stopImpl");
    }

    protected void destroyImpl() {
        logger.unimplemented("destroyImpl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                if (this.params.faaTimer != null) {
                    logger.unimplemented("start(faaTimer)");
                }
                this.startImpl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.stopImpl();
            }
        }
    }

    @Override
    public String toString() {
        return "FrameAccurateAnimation";
    }
}

