// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#include "stdcomplex.h"

#include <iostream>

StdComplex::StdComplex() noexcept = default;

StdComplex::StdComplex(double re, double img) noexcept : m_impl(re, img)
{
}

StdComplex::StdComplex(const Impl &impl) noexcept : m_impl(impl)
{
}

std::ostream &operator<<(std::ostream &str, const StdComplex &c)
{
    str << "Complex(" << c.real() << ", " << c.imag() << ')';
    return str;
}
