// Copyright (C) 2021 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef PYSIDECLEANUP_H
#define PYSIDECLEANUP_H

#include <pysidemacros.h>

namespace PySide
{

using CleanupFunction = void(*)();

/// Register a function to be called before python dies
PYSIDE_API void registerCleanupFunction(CleanupFunction func);
PYSIDE_API void runCleanupFunctions();

} //namespace PySide

#endif // PYSIDECLEANUP_H
