# -*- coding: utf-8 -*-
# $Id: prime.py,v 1.9 2005/08/12 05:07:17 jwp Exp $
##
# Copyright 2005, PostgresPy Project.
# http://python.projects.postgresql.org
##
# imp/src/prime.py,v 1.1 2004/12/15 06:21:17 flaw
# imp/src/pg.py,v 1.2 2004/10/08 20:24:12 flaw
##
# This pure python module is bound to the extension module that it imports.
# Without the extension module, this module is useless, and without this
# module, the extension module is incomplete.
##
'Postgres backend interface'
import sys, os
self = sys.modules[__name__]
mpath = self.__file__
pvpath = os.path.dirname(mpath)
ppath = os.path.dirname(pvpath)
sys.path = [pvpath, ppath] + sys.path
sys.modules['Postgres'] = self
del os, self, ppath, pvpath, mpath
__name__ = 'Postgres'

from _prime import *
sys.modules['Postgres.exceptions'] = exceptions
sys.modules['Postgres.exceptions.code'] = exceptions.code
del sys

Catalog = Namespace(Const["PG_CATALOG_NAMESPACE"])

INV_READ =	0x00040000
INV_WRITE =	0x00020000
INV_RW = INV_READ | INV_WRITE

_closed_file_error = ValueError("I/O operation on closed LargeObject")
_invalidmode_error = lambda x: IOError("invalid mode '%s'" %(x,))

from StringIO import StringIO
class LargeObject(object):
	_create = Function(957)
	_unlink = Function(964)
	_open = Function(952)
	_tell = Function(958)
	_seek = Function(956)
	_read = Function(954)
	_write = Function(955)
	_close = Function(953)

	closed = True
	oid = 0
	lod = 0
	mode = ""

	def fileno(self):
		return self.lod

	def __del__(self):
		if not self.closed:
			self.close()

	def __repr__(self):
		if self.closed:
			state = 'closed'
		else:
			state = 'open'
		return "<%s large object '%d' mode '%s' at %s>" % (
			state, int(self.oid), self.mode, hex(id(self)),
		)

	def __init__(self, oid = None, mode = 'r'):
		if oid is None:
			oid = LargeObject._create(INV_RW)
			mc = INV_RW
			mode = 'rw'
		else:
			mc = 0
			for m in mode:
				if m == 'r':
					mc |= INV_READ
				elif m == 'w':
					mc |= INV_WRITE
				else:
					raise _invalidmode_error(m)
			mode = ""
			if mc & INV_READ:
				mode += 'r'
			if mc & INV_WRITE:
				mode += 'rw'

		self.mode = mode
		self.oid = oid
		self.lod = LargeObject._open(oid, mc)
		self.closed = False

	def read(self, amt = None):
		if self.closed: raise _closed_file_error
		lod = self.lod
		ator = 1024
		string = StringIO()
		if amt is None:
			data = LargeObject._read(lod, ator)
			while len(data) > 0:
				string.write(data)
				data = LargeObject._read(lod, ator)
		else:
			while amt > 0:
				if amt < 1024:
					ator = amt
				data = LargeObject._read(lod, ator)
				amt -= len(data)

		string.seek(0)
		return string.read()

	def readline(self):
		if self.closed: raise _closed_file_error
		lod = self.lod
		string = StringIO()
		char = LargeObject._read(lod, 1).data
		string.write(char)
		while char != '' and char != '\n':
			char = LargeObject._read(lod, 1)
			string.write(char)
		string.seek(0)
		return string.read()

	def write(self, data):
		if self.closed: raise _closed_file_error
		LargeObject._write(self.lod, data)

	def tell(self):
		if self.closed: raise _closed_file_error
		return int(LargeObject._tell(self.lod))

	def seek(self, offset, whence = 0):
		if self.closed: raise _closed_file_error
		LargeObject._seek(self.lod, offset, whence)

	def close(self):
		if not self.closed:
			self.closed = True
			LargeObject._close(self.lod)

	def unlink(self):
		if not self.closed:
			self.close()
		LargeObject._unlink(self.oid)
