"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const exposes = __importStar(require("../lib/exposes"));
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const reporting = __importStar(require("../lib/reporting"));
const utils_1 = require("../lib/utils");
const e = exposes.presets;
const lockExtend = (meta = {}, lockStateOptions = null, binds = ['closuresDoorLock', 'genPowerCfg']) => {
    return {
        fromZigbee: [fromZigbee_1.default.lock, fromZigbee_1.default.battery, fromZigbee_1.default.lock_operation_event, fromZigbee_1.default.lock_programming_event, fromZigbee_1.default.lock_pin_code_response,
            fromZigbee_1.default.lock_user_status_response],
        toZigbee: [toZigbee_1.default.lock, toZigbee_1.default.pincode_lock, toZigbee_1.default.lock_userstatus, toZigbee_1.default.lock_auto_relock_time, toZigbee_1.default.lock_sound_volume],
        meta: { pinCodeCount: 250, ...meta },
        exposes: [e.lock(), e.battery(), e.pincode(), e.lock_action(), e.lock_action_source_name(), e.lock_action_user(),
            e.auto_relock_time().withValueMin(0).withValueMax(3600), e.sound_volume(), e.battery_low()],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, binds);
            await reporting.lockState(endpoint, lockStateOptions);
            await reporting.batteryPercentageRemaining(endpoint);
            try {
                await reporting.batteryAlarmState(endpoint);
            }
            catch (e) {
                // Fails for some: https://github.com/Koenkk/zigbee-herdsman-converters/pull/5414
            }
        },
    };
};
const fzLocal = {
    c4_lock_operation_event: {
        cluster: 'genAlarms',
        type: ['commandAlarm'],
        convert: async (model, msg, publish, options, meta) => {
            let result = {};
            if (msg.data.clusterid == 64512) {
                const alarmcode = msg.data.alarmcode;
                const lookup = {
                    9: { action: 'error_jammed', state: 'UNLOCK', lock_state: 'not_fully_locked' },
                    21: { action: 'manual_lock', state: 'LOCK', lock_state: 'locked' },
                    22: { action: 'manual_unlock', state: 'UNLOCK', lock_state: 'unlocked' },
                    24: { action: 'lock', state: 'LOCK', lock_state: 'locked' },
                    25: { action: 'unlock', state: 'UNLOCK', lock_state: 'unlocked' },
                    27: { action: 'auto_lock', state: 'LOCK', lock_state: 'locked' },
                };
                if (!(0, utils_1.getFromLookup)(alarmcode, lookup)) {
                    result.action = 'unknown';
                    meta.logger.warn(`zigbee-herdsman-converters:Yale Lock: Unrecognized Operation Event (${alarmcode})`);
                    // We need to read the lock state as the alarm code is unknown
                    try {
                        await msg.endpoint.read('closuresDoorLock', ['lockState']);
                    }
                    catch (error) {
                        meta.logger.warn(`zigbee-herdsman-converters:Yale Lock: failed to read lock state`);
                    }
                }
                else {
                    result = (0, utils_1.getFromLookup)(alarmcode, lookup);
                }
            }
            return result;
        },
    },
};
const definitions = [
    {
        zigbeeModel: ['YRD446 BLE TSDB'],
        model: 'YRD426NRSC',
        vendor: 'Yale',
        description: 'Assure lock',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD226 TSDB', 'YRD226L TSDB'],
        model: 'YRD226HA2619',
        vendor: 'Yale',
        description: 'Assure lock',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD256 TSDB', 'YRD256L TSDB'],
        model: 'YRD256HA20BP',
        vendor: 'Yale',
        description: 'Assure lock SL',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['0600000001'],
        model: 'YMF30',
        vendor: 'Yale',
        description: 'Digital lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['iZBModule01', '0700000001'],
        model: 'YMF40/YDM4109+/YDF40',
        vendor: 'Yale',
        description: 'Real living lock / Intelligent biometric digital lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['YRD210 PB DB'],
        model: 'YRD210-HA-605',
        vendor: 'Yale',
        description: 'Real living keyless push button deadbolt lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['YRL220 TS LL'],
        // The zigbee module card indicate that the module will work on YRD 221 and YRD 221RL also
        model: 'YRL-220L',
        vendor: 'Yale',
        description: 'Real living keyless leveler lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['YRD226/246 TSDB'],
        model: 'YRD226/246 TSDB',
        vendor: 'Yale',
        description: 'Assure lock',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD220/240 TSDB'],
        model: 'YRD220/YRD221',
        vendor: 'Yale',
        description: 'Lockwood keyless push button deadbolt lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['YRD246 TSDB'],
        model: 'YRD246HA20BP',
        vendor: 'Yale',
        description: 'Assure lock key free deadbolt with Zigbee',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['YRD216 PBDB'],
        model: 'YRD216-HA2-619',
        vendor: 'Yale',
        description: 'Real living keyless push button deadbolt lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        zigbeeModel: ['YRL226L TS'],
        model: 'YRL226L TS',
        vendor: 'Yale',
        description: 'Assure lock SL',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRL226 TS'],
        model: 'YRL226 TS',
        vendor: 'Yale',
        description: 'Assure lock SL',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD410 TS'],
        model: 'YRD410-BLE',
        vendor: 'Yale',
        description: 'Assure lock 2',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD420 TS'],
        model: 'YRD420-BLE',
        vendor: 'Yale',
        description: 'Assure lock 2',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD430 TS'],
        model: 'YRD430-BLE',
        vendor: 'Yale',
        description: 'Assure lock 2',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['YRD450 TS'],
        model: 'YRD450-BLE',
        vendor: 'Yale',
        description: 'Assure lock 2',
        extend: lockExtend(),
    },
    {
        // Appears to be a slightly rebranded Assure lock SL
        // Just with Lockwood | Assa Abloy branding instead of Yale
        // Appears to have been part of a deal with Telstra, hence the T-Lock name
        zigbeeModel: ['YDD-D4F0 TSDB'],
        model: 'YDD-D4F0-TSDB',
        vendor: 'Yale',
        description: 'Lockwood T-Lock',
        extend: lockExtend(),
    },
    {
        zigbeeModel: ['c700000202', '06ffff2029'],
        model: 'YDF40',
        vendor: 'Yale',
        description: 'Real living lock / Intelligent biometric digital lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }, { max: 900 }, ['closuresDoorLock']),
    },
    {
        zigbeeModel: ['06ffff2027'],
        model: 'YMF40A RL',
        vendor: 'Yale',
        description: 'Real living lock / Intelligent biometric digital lock',
        extend: lockExtend({ battery: { dontDividePercentage: true } }),
    },
    {
        fingerprint: [{
                type: 'EndDevice',
                manufacturerName: 'Yale',
                manufacturerID: 43690,
                powerSource: 'Battery',
                endpoints: [
                    { ID: 1, profileID: 260, deviceID: 10, inputClusters: [0, 9, 10, 257, 64512, 1], outputClusters: [] },
                    { ID: 196, profileID: 260, deviceID: 10, inputClusters: [1], outputClusters: [] },
                ]
            },
        ],
        model: 'ZYA-C4-MOD-S',
        vendor: 'Yale',
        description: 'Control4 module for Yale KeyFree/Keyless/Doorman/Assure/nexTouch locks',
        fromZigbee: [fromZigbee_1.default.lock, fzLocal.c4_lock_operation_event],
        toZigbee: [toZigbee_1.default.lock],
        exposes: [e.lock(), e.lock_action()],
    },
];
module.exports = definitions;
//# sourceMappingURL=yale.js.map