/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.BsdThreadContextFactory;

class BsdThread
implements ThreadProxy {
    private BsdDebugger debugger;
    private int thread_id;
    private long unique_thread_id;

    BsdThread(BsdDebugger debugger, Address threadIdAddr, Address uniqueThreadIdAddr) {
        this.debugger = debugger;
        this.thread_id = (int)threadIdAddr.getCIntegerAt(0L, 4L, true);
        this.unique_thread_id = uniqueThreadIdAddr.getCIntegerAt(0L, 8L, true);
    }

    BsdThread(BsdDebugger debugger, long id) {
        this.debugger = debugger;
        this.thread_id = (int)id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BsdThread)) {
            return false;
        }
        return ((BsdThread)obj).thread_id == this.thread_id;
    }

    public int hashCode() {
        return this.thread_id;
    }

    public String toString() {
        return Integer.toString(this.thread_id);
    }

    @Override
    public ThreadContext getContext() throws IllegalThreadStateException {
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.unique_thread_id);
        ThreadContext context = BsdThreadContextFactory.createThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    @Override
    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    @Override
    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }
}

