/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.jsp.tagext.TagVariableInfo;
import jakarta.servlet.jsp.tagext.VariableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;

class ScriptingVariabler {
    private static final Integer MAX_SCOPE = Integer.MAX_VALUE;

    ScriptingVariabler() {
    }

    public static void set(Node.Nodes nodes, ErrorDispatcher errorDispatcher) throws JasperException {
        nodes.visit(new CustomTagCounter());
        nodes.visit(new ScriptingVariableVisitor(errorDispatcher));
    }

    private static class CustomTagCounter
    extends Node.Visitor {
        private int count;
        private Node.CustomTag parent;

        private CustomTagCounter() {
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            customTag.setCustomTagParent(this.parent);
            Node.CustomTag customTag2 = this.parent;
            this.parent = customTag;
            this.visitBody(customTag);
            this.parent = customTag2;
            customTag.setNumCount(this.count++);
        }
    }

    private static class ScriptingVariableVisitor
    extends Node.Visitor {
        private final ErrorDispatcher err;
        private final Map<String, Integer> scriptVars;

        ScriptingVariableVisitor(ErrorDispatcher errorDispatcher) {
            this.err = errorDispatcher;
            this.scriptVars = new HashMap<String, Integer>();
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.setScriptingVars(customTag, 1);
            this.setScriptingVars(customTag, 0);
            this.visitBody(customTag);
            this.setScriptingVars(customTag, 2);
        }

        private void setScriptingVars(Node.CustomTag customTag, int n) throws JasperException {
            TagVariableInfo[] tagVariableInfoArray = customTag.getTagVariableInfos();
            VariableInfo[] variableInfoArray = customTag.getVariableInfos();
            if (tagVariableInfoArray.length == 0 && variableInfoArray.length == 0) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Integer n2 = null;
            Node.CustomTag customTag2 = customTag.getCustomTagParent();
            n2 = n == 1 || n == 2 ? (customTag2 == null ? MAX_SCOPE : customTag2.getNumCount()) : customTag.getNumCount();
            if (variableInfoArray.length > 0) {
                for (VariableInfo variableInfo : variableInfoArray) {
                    String string;
                    Integer n3;
                    if (variableInfo.getScope() != n || !variableInfo.getDeclare() || (n3 = this.scriptVars.get(string = variableInfo.getVarName())) != null && n2.compareTo(n3) <= 0) continue;
                    this.scriptVars.put(string, n2);
                    arrayList.add(variableInfo);
                }
            } else {
                for (TagVariableInfo tagVariableInfo : tagVariableInfoArray) {
                    Integer n4;
                    if (tagVariableInfo.getScope() != n || !tagVariableInfo.getDeclare()) continue;
                    String string = tagVariableInfo.getNameGiven();
                    if (string == null && (string = customTag.getTagData().getAttributeString(tagVariableInfo.getNameFromAttribute())) == null) {
                        this.err.jspError((Node)customTag, "jsp.error.scripting.variable.missing_name", tagVariableInfo.getNameFromAttribute());
                    }
                    if ((n4 = this.scriptVars.get(string)) != null && n2.compareTo(n4) <= 0) continue;
                    this.scriptVars.put(string, n2);
                    arrayList.add(tagVariableInfo);
                }
            }
            customTag.setScriptingVars(arrayList, n);
        }
    }
}

