/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class AbstractRef
extends Reference {
    private static final long serialVersionUID = 1L;

    public AbstractRef(String string) {
        super(string);
    }

    public AbstractRef(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    public final String getFactoryClassName() {
        String string = super.getFactoryClassName();
        if (string != null) {
            return string;
        }
        string = System.getProperty("java.naming.factory.object");
        if (string != null) {
            return null;
        }
        return this.getDefaultFactoryClassName();
    }

    protected abstract String getDefaultFactoryClassName();

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[className=");
        stringBuilder.append(this.getClassName());
        stringBuilder.append(",factoryClassLocation=");
        stringBuilder.append(this.getFactoryClassLocation());
        stringBuilder.append(",factoryClassName=");
        stringBuilder.append(this.getFactoryClassName());
        Enumeration<RefAddr> enumeration = this.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr refAddr = enumeration.nextElement();
            stringBuilder.append(",{type=");
            stringBuilder.append(refAddr.getType());
            stringBuilder.append(",content=");
            stringBuilder.append(refAddr.getContent());
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

