/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.JreCompat;

public class CharsetMapper {
    public static final String DEFAULT_RESOURCE = "/org/apache/catalina/util/CharsetMapperDefault.properties";
    private Properties map = new Properties();

    public CharsetMapper() {
        this(DEFAULT_RESOURCE);
    }

    public CharsetMapper(String string) {
        if (JreCompat.isGraalAvailable()) {
            this.map.put("en", "ISO-8859-1");
        } else {
            try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
                this.map.load(inputStream);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                throw new IllegalArgumentException(throwable);
            }
        }
    }

    public String getCharset(Locale locale) {
        String string = this.map.getProperty(locale.toString());
        if (string == null && (string = this.map.getProperty(locale.getLanguage() + "_" + locale.getCountry())) == null) {
            string = this.map.getProperty(locale.getLanguage());
        }
        return string;
    }

    public void addCharsetMappingFromDeploymentDescriptor(String string, String string2) {
        this.map.put(string, string2);
    }
}

