/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JspConfig {
    private final Log log = LogFactory.getLog(JspConfig.class);
    private List<JspPropertyGroup> jspProperties = null;
    private final ServletContext ctxt;
    private volatile boolean initialized = false;
    private static final String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private static final String defaultIsScriptingInvalid = null;
    private String defaultDeferedSyntaxAllowedAsLiteral = null;
    private static final String defaultTrimDirectiveWhitespaces = null;
    private static final String defaultDefaultContentType = null;
    private static final String defaultBuffer = null;
    private static final String defaultErrorOnUndeclaredNamespace = "false";
    private JspProperty defaultJspProperty;

    public JspConfig(ServletContext servletContext) {
        this.ctxt = servletContext;
    }

    private void processWebDotXml() {
        JspConfigDescriptor jspConfigDescriptor;
        if (this.ctxt.getEffectiveMajorVersion() < 2) {
            this.defaultIsELIgnored = "true";
            this.defaultDeferedSyntaxAllowedAsLiteral = "true";
            return;
        }
        if (this.ctxt.getEffectiveMajorVersion() == 2) {
            if (this.ctxt.getEffectiveMinorVersion() < 5) {
                this.defaultDeferedSyntaxAllowedAsLiteral = "true";
            }
            if (this.ctxt.getEffectiveMinorVersion() < 4) {
                this.defaultIsELIgnored = "true";
                return;
            }
        }
        if ((jspConfigDescriptor = this.ctxt.getJspConfigDescriptor()) == null) {
            return;
        }
        this.jspProperties = new ArrayList<JspPropertyGroup>();
        Collection collection = jspConfigDescriptor.getJspPropertyGroups();
        for (JspPropertyGroupDescriptor jspPropertyGroupDescriptor : collection) {
            Collection collection2 = jspPropertyGroupDescriptor.getUrlPatterns();
            if (collection2.size() == 0) continue;
            JspProperty jspProperty = new JspProperty(jspPropertyGroupDescriptor.getIsXml(), jspPropertyGroupDescriptor.getElIgnored(), jspPropertyGroupDescriptor.getScriptingInvalid(), jspPropertyGroupDescriptor.getPageEncoding(), jspPropertyGroupDescriptor.getIncludePreludes(), jspPropertyGroupDescriptor.getIncludeCodas(), jspPropertyGroupDescriptor.getDeferredSyntaxAllowedAsLiteral(), jspPropertyGroupDescriptor.getTrimDirectiveWhitespaces(), jspPropertyGroupDescriptor.getDefaultContentType(), jspPropertyGroupDescriptor.getBuffer(), jspPropertyGroupDescriptor.getErrorOnUndeclaredNamespace());
            for (String string : collection2) {
                String string2 = null;
                String string3 = null;
                if (string.indexOf(42) < 0) {
                    string2 = string;
                } else {
                    String string4;
                    int n = string.lastIndexOf(47);
                    if (n >= 0) {
                        string2 = string.substring(0, n + 1);
                        string4 = string.substring(n + 1);
                    } else {
                        string4 = string;
                    }
                    if (string4.equals("*")) {
                        string3 = "*";
                    } else if (string4.startsWith("*.")) {
                        string3 = string4.substring(string4.indexOf(46) + 1);
                    }
                    boolean bl = "*".equals(string3);
                    if (string2 == null && (string3 == null || bl) || string2 != null && !bl) {
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn((Object)Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", string));
                        continue;
                    }
                }
                JspPropertyGroup jspPropertyGroup = new JspPropertyGroup(string2, string3, jspProperty);
                this.jspProperties.add(jspPropertyGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.initialized) {
            JspConfig jspConfig = this;
            synchronized (jspConfig) {
                if (!this.initialized) {
                    this.processWebDotXml();
                    this.defaultJspProperty = new JspProperty(defaultIsXml, this.defaultIsELIgnored, defaultIsScriptingInvalid, null, null, null, this.defaultDeferedSyntaxAllowedAsLiteral, defaultTrimDirectiveWhitespaces, defaultDefaultContentType, defaultBuffer, defaultErrorOnUndeclaredNamespace);
                    this.initialized = true;
                }
            }
        }
    }

    private JspPropertyGroup selectProperty(JspPropertyGroup jspPropertyGroup, JspPropertyGroup jspPropertyGroup2) {
        if (jspPropertyGroup == null) {
            return jspPropertyGroup2;
        }
        if (jspPropertyGroup.getExtension() == null) {
            return jspPropertyGroup;
        }
        if (jspPropertyGroup2.getExtension() == null) {
            return jspPropertyGroup2;
        }
        String string = jspPropertyGroup.getPath();
        String string2 = jspPropertyGroup2.getPath();
        if (string == null && string2 == null) {
            return jspPropertyGroup;
        }
        if (string == null && string2 != null) {
            return jspPropertyGroup2;
        }
        if (string != null && string2 == null) {
            return jspPropertyGroup;
        }
        if (string.length() >= string2.length()) {
            return jspPropertyGroup;
        }
        return jspPropertyGroup2;
    }

    /*
     * WARNING - void declaration
     */
    public JspProperty findJspProperty(String string) {
        void var17_20;
        String string2;
        String string3;
        Object object;
        this.init();
        if (this.jspProperties == null || string.endsWith(".tag") || string.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String string4 = null;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string4 = string.substring(0, n + 1);
        }
        String string5 = null;
        n = string.lastIndexOf(46);
        if (n >= 0) {
            string5 = string.substring(n + 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        JspPropertyGroup jspPropertyGroup = null;
        JspPropertyGroup jspPropertyGroup2 = null;
        JspPropertyGroup jspPropertyGroup3 = null;
        JspPropertyGroup jspPropertyGroup4 = null;
        JspPropertyGroup jspPropertyGroup5 = null;
        JspPropertyGroup jspPropertyGroup6 = null;
        JspPropertyGroup jspPropertyGroup7 = null;
        JspPropertyGroup jspPropertyGroup8 = null;
        JspPropertyGroup jspPropertyGroup9 = null;
        for (JspPropertyGroup object22 : this.jspProperties) {
            object = object22.getJspProperty();
            string3 = object22.getExtension();
            string2 = object22.getPath();
            if (string3 != null ? string2 != null && string4 != null && !string4.startsWith(string2) || !string3.equals("*") && !string3.equals(string5) : !string.equals(string2)) continue;
            if (((JspProperty)object).getIncludePrelude() != null) {
                arrayList.addAll(((JspProperty)object).getIncludePrelude());
            }
            if (((JspProperty)object).getIncludeCoda() != null) {
                arrayList2.addAll(((JspProperty)object).getIncludeCoda());
            }
            if (((JspProperty)object).isXml() != null) {
                jspPropertyGroup = this.selectProperty(jspPropertyGroup, object22);
            }
            if (((JspProperty)object).isELIgnored() != null) {
                jspPropertyGroup2 = this.selectProperty(jspPropertyGroup2, object22);
            }
            if (((JspProperty)object).isScriptingInvalid() != null) {
                jspPropertyGroup3 = this.selectProperty(jspPropertyGroup3, object22);
            }
            if (((JspProperty)object).getPageEncoding() != null) {
                jspPropertyGroup4 = this.selectProperty(jspPropertyGroup4, object22);
            }
            if (((JspProperty)object).isDeferedSyntaxAllowedAsLiteral() != null) {
                jspPropertyGroup5 = this.selectProperty(jspPropertyGroup5, object22);
            }
            if (((JspProperty)object).isTrimDirectiveWhitespaces() != null) {
                jspPropertyGroup6 = this.selectProperty(jspPropertyGroup6, object22);
            }
            if (((JspProperty)object).getDefaultContentType() != null) {
                jspPropertyGroup7 = this.selectProperty(jspPropertyGroup7, object22);
            }
            if (((JspProperty)object).getBuffer() != null) {
                jspPropertyGroup8 = this.selectProperty(jspPropertyGroup8, object22);
            }
            if (((JspProperty)object).isErrorOnUndeclaredNamespace() == null) continue;
            jspPropertyGroup9 = this.selectProperty(jspPropertyGroup9, object22);
        }
        Object object3 = defaultIsXml;
        String string6 = this.defaultIsELIgnored;
        object = defaultIsScriptingInvalid;
        string3 = null;
        string2 = this.defaultDeferedSyntaxAllowedAsLiteral;
        String string7 = defaultTrimDirectiveWhitespaces;
        String string8 = defaultDefaultContentType;
        String string9 = defaultBuffer;
        String string10 = defaultErrorOnUndeclaredNamespace;
        if (jspPropertyGroup != null) {
            object3 = jspPropertyGroup.getJspProperty().isXml();
        }
        if (jspPropertyGroup2 != null) {
            String string11 = jspPropertyGroup2.getJspProperty().isELIgnored();
        }
        if (jspPropertyGroup3 != null) {
            object = jspPropertyGroup3.getJspProperty().isScriptingInvalid();
        }
        if (jspPropertyGroup4 != null) {
            string3 = jspPropertyGroup4.getJspProperty().getPageEncoding();
        }
        if (jspPropertyGroup5 != null) {
            string2 = jspPropertyGroup5.getJspProperty().isDeferedSyntaxAllowedAsLiteral();
        }
        if (jspPropertyGroup6 != null) {
            string7 = jspPropertyGroup6.getJspProperty().isTrimDirectiveWhitespaces();
        }
        if (jspPropertyGroup7 != null) {
            string8 = jspPropertyGroup7.getJspProperty().getDefaultContentType();
        }
        if (jspPropertyGroup8 != null) {
            string9 = jspPropertyGroup8.getJspProperty().getBuffer();
        }
        if (jspPropertyGroup9 != null) {
            string10 = jspPropertyGroup9.getJspProperty().isErrorOnUndeclaredNamespace();
        }
        return new JspProperty((String)object3, (String)var17_20, (String)object, string3, arrayList, arrayList2, string2, string7, string8, string9, string10);
    }

    public boolean isJspPage(String string) {
        this.init();
        if (this.jspProperties == null) {
            return false;
        }
        String string2 = null;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string2 = string.substring(0, n + 1);
        }
        String string3 = null;
        n = string.lastIndexOf(46);
        if (n >= 0) {
            string3 = string.substring(n + 1);
        }
        for (JspPropertyGroup jspPropertyGroup : this.jspProperties) {
            String string4 = jspPropertyGroup.getExtension();
            String string5 = jspPropertyGroup.getPath();
            if (!(string4 == null ? string.equals(string5) : !(string5 != null && !string5.equals(string2) || !string4.equals("*") && !string4.equals(string3)))) continue;
            return true;
        }
        return false;
    }

    public static class JspProperty {
        private final String isXml;
        private final String elIgnored;
        private final String scriptingInvalid;
        private final String pageEncoding;
        private final Collection<String> includePrelude;
        private final Collection<String> includeCoda;
        private final String deferedSyntaxAllowedAsLiteral;
        private final String trimDirectiveWhitespaces;
        private final String defaultContentType;
        private final String buffer;
        private final String errorOnUndeclaredNamespace;

        public JspProperty(String string, String string2, String string3, String string4, Collection<String> collection, Collection<String> collection2, String string5, String string6, String string7, String string8, String string9) {
            this.isXml = string;
            this.elIgnored = string2;
            this.scriptingInvalid = string3;
            this.pageEncoding = string4;
            this.includePrelude = collection;
            this.includeCoda = collection2;
            this.deferedSyntaxAllowedAsLiteral = string5;
            this.trimDirectiveWhitespaces = string6;
            this.defaultContentType = string7;
            this.buffer = string8;
            this.errorOnUndeclaredNamespace = string9;
        }

        public String isXml() {
            return this.isXml;
        }

        public String isELIgnored() {
            return this.elIgnored;
        }

        public String isScriptingInvalid() {
            return this.scriptingInvalid;
        }

        public String getPageEncoding() {
            return this.pageEncoding;
        }

        public Collection<String> getIncludePrelude() {
            return this.includePrelude;
        }

        public Collection<String> getIncludeCoda() {
            return this.includeCoda;
        }

        public String isDeferedSyntaxAllowedAsLiteral() {
            return this.deferedSyntaxAllowedAsLiteral;
        }

        public String isTrimDirectiveWhitespaces() {
            return this.trimDirectiveWhitespaces;
        }

        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        public String getBuffer() {
            return this.buffer;
        }

        public String isErrorOnUndeclaredNamespace() {
            return this.errorOnUndeclaredNamespace;
        }
    }

    public static class JspPropertyGroup {
        private final String path;
        private final String extension;
        private final JspProperty jspProperty;

        JspPropertyGroup(String string, String string2, JspProperty jspProperty) {
            this.path = string;
            this.extension = string2;
            this.jspProperty = jspProperty;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public JspProperty getJspProperty() {
            return this.jspProperty;
        }
    }
}

