/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static void load(KeyStore keyStore, InputStream inputStream, char[] cArray) throws NoSuchAlgorithmException, CertificateException, IOException {
        if (keyStore.getType().equals("PKCS12")) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            keyStore.load(byteArrayInputStream, cArray);
        } else {
            keyStore.load(inputStream, cArray);
        }
    }
}

