/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

public class AbandonedConfig {
    private static final Duration DEFAULT_REMOVE_ABANDONED_TIMEOUT_DURATION = Duration.ofMinutes(5L);
    private boolean removeAbandonedOnBorrow;
    private boolean removeAbandonedOnMaintenance;
    private Duration removeAbandonedTimeoutDuration = DEFAULT_REMOVE_ABANDONED_TIMEOUT_DURATION;
    private boolean logAbandoned;
    private boolean requireFullStackTrace = true;
    private PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
    private boolean useUsageTracking;

    public static AbandonedConfig copy(AbandonedConfig abandonedConfig) {
        return abandonedConfig == null ? null : new AbandonedConfig(abandonedConfig);
    }

    public AbandonedConfig() {
    }

    private AbandonedConfig(AbandonedConfig abandonedConfig) {
        this.setLogAbandoned(abandonedConfig.getLogAbandoned());
        this.setLogWriter(abandonedConfig.getLogWriter());
        this.setRemoveAbandonedOnBorrow(abandonedConfig.getRemoveAbandonedOnBorrow());
        this.setRemoveAbandonedOnMaintenance(abandonedConfig.getRemoveAbandonedOnMaintenance());
        this.setRemoveAbandonedTimeout(abandonedConfig.getRemoveAbandonedTimeoutDuration());
        this.setUseUsageTracking(abandonedConfig.getUseUsageTracking());
        this.setRequireFullStackTrace(abandonedConfig.getRequireFullStackTrace());
    }

    public boolean getLogAbandoned() {
        return this.logAbandoned;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public boolean getRemoveAbandonedOnBorrow() {
        return this.removeAbandonedOnBorrow;
    }

    public boolean getRemoveAbandonedOnMaintenance() {
        return this.removeAbandonedOnMaintenance;
    }

    @Deprecated
    public int getRemoveAbandonedTimeout() {
        return (int)this.removeAbandonedTimeoutDuration.getSeconds();
    }

    public Duration getRemoveAbandonedTimeoutDuration() {
        return this.removeAbandonedTimeoutDuration;
    }

    public boolean getRequireFullStackTrace() {
        return this.requireFullStackTrace;
    }

    public boolean getUseUsageTracking() {
        return this.useUsageTracking;
    }

    public void setLogAbandoned(boolean bl) {
        this.logAbandoned = bl;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setRemoveAbandonedOnBorrow(boolean bl) {
        this.removeAbandonedOnBorrow = bl;
    }

    public void setRemoveAbandonedOnMaintenance(boolean bl) {
        this.removeAbandonedOnMaintenance = bl;
    }

    public void setRemoveAbandonedTimeout(Duration duration) {
        this.removeAbandonedTimeoutDuration = PoolImplUtils.nonNull(duration, DEFAULT_REMOVE_ABANDONED_TIMEOUT_DURATION);
    }

    @Deprecated
    public void setRemoveAbandonedTimeout(int n) {
        this.setRemoveAbandonedTimeout(Duration.ofSeconds(n));
    }

    public void setRequireFullStackTrace(boolean bl) {
        this.requireFullStackTrace = bl;
    }

    public void setUseUsageTracking(boolean bl) {
        this.useUsageTracking = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AbandonedConfig [removeAbandonedOnBorrow=");
        stringBuilder.append(this.removeAbandonedOnBorrow);
        stringBuilder.append(", removeAbandonedOnMaintenance=");
        stringBuilder.append(this.removeAbandonedOnMaintenance);
        stringBuilder.append(", removeAbandonedTimeoutDuration=");
        stringBuilder.append(this.removeAbandonedTimeoutDuration);
        stringBuilder.append(", logAbandoned=");
        stringBuilder.append(this.logAbandoned);
        stringBuilder.append(", logWriter=");
        stringBuilder.append(this.logWriter);
        stringBuilder.append(", useUsageTracking=");
        stringBuilder.append(this.useUsageTracking);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

