/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HeaderUtil;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http11InputBuffer
implements InputBuffer,
ApplicationBufferHandler {
    private static final Log log = LogFactory.getLog(Http11InputBuffer.class);
    private static final StringManager sm = StringManager.getManager(Http11InputBuffer.class);
    private static final byte[] CLIENT_PREFACE_START = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private final Request request;
    private final MimeHeaders headers;
    private final boolean rejectIllegalHeader;
    private volatile boolean parsingHeader;
    private boolean swallowInput;
    private ByteBuffer byteBuffer;
    private int end;
    private SocketWrapperBase<?> wrapper;
    private InputBuffer inputStreamInputBuffer;
    private InputFilter[] filterLibrary;
    private InputFilter[] activeFilters;
    private int lastActiveFilter;
    private byte prevChr = 0;
    private byte chr = 0;
    private volatile boolean parsingRequestLine;
    private int parsingRequestLinePhase = 0;
    private boolean parsingRequestLineEol = false;
    private int parsingRequestLineStart = 0;
    private int parsingRequestLineQPos = -1;
    private HeaderParsePosition headerParsePos;
    private final HeaderParseData headerData = new HeaderParseData();
    private final HttpParser httpParser;
    private final int headerBufferSize;
    private int socketReadBufferSize;

    public Http11InputBuffer(Request request, int n, boolean bl, HttpParser httpParser) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.headerBufferSize = n;
        this.rejectIllegalHeader = bl;
        this.httpParser = httpParser;
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.swallowInput = true;
        this.inputStreamInputBuffer = new SocketInputBuffer();
    }

    void addFilter(InputFilter inputFilter) {
        if (inputFilter == null) {
            throw new NullPointerException(sm.getString("iib.filter.npe"));
        }
        InputFilter[] inputFilterArray = Arrays.copyOf(this.filterLibrary, this.filterLibrary.length + 1);
        inputFilterArray[this.filterLibrary.length] = inputFilter;
        this.filterLibrary = inputFilterArray;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    void addActiveFilter(InputFilter inputFilter) {
        if (this.lastActiveFilter == -1) {
            inputFilter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != inputFilter) continue;
                return;
            }
            inputFilter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = inputFilter;
        inputFilter.setRequest(this.request);
    }

    void setSwallowInput(boolean bl) {
        this.swallowInput = bl;
    }

    @Override
    public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(applicationBufferHandler);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(applicationBufferHandler);
    }

    void recycle() {
        this.wrapper = null;
        this.request.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.byteBuffer.limit(0).position(0);
        this.lastActiveFilter = -1;
        this.swallowInput = true;
        this.chr = 0;
        this.prevChr = 0;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
        this.parsingRequestLine = true;
        this.parsingHeader = true;
    }

    void nextRequest() {
        this.request.recycle();
        if (this.byteBuffer.position() > 0) {
            if (this.byteBuffer.remaining() > 0) {
                this.byteBuffer.compact();
                this.byteBuffer.flip();
            } else {
                this.byteBuffer.position(0).limit(0);
            }
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    boolean parseRequestLine(boolean bl, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase < 2) {
            do {
                if (this.byteBuffer.position() >= this.byteBuffer.limit()) {
                    if (bl) {
                        this.wrapper.setReadTimeout(n2);
                    }
                    if (!this.fill(false)) {
                        this.parsingRequestLinePhase = 1;
                        return false;
                    }
                    this.wrapper.setReadTimeout(n);
                }
                if (!bl && this.byteBuffer.position() == 0 && this.byteBuffer.limit() >= CLIENT_PREFACE_START.length) {
                    n4 = 1;
                    for (n3 = 0; n3 < CLIENT_PREFACE_START.length && n4 != 0; ++n3) {
                        if (CLIENT_PREFACE_START[n3] == this.byteBuffer.get(n3)) continue;
                        n4 = 0;
                    }
                    if (n4 != 0) {
                        this.parsingRequestLinePhase = -1;
                        return false;
                    }
                }
                if (this.request.getStartTimeNanos() < 0L) {
                    this.request.setStartTimeNanos(System.nanoTime());
                }
                this.chr = this.byteBuffer.get();
            } while (this.chr == 13 || this.chr == 10);
            this.byteBuffer.position(this.byteBuffer.position() - 1);
            this.parsingRequestLineStart = this.byteBuffer.position();
            this.parsingRequestLinePhase = 2;
        }
        if (this.parsingRequestLinePhase == 2) {
            n4 = 0;
            while (n4 == 0) {
                if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                    return false;
                }
                n3 = this.byteBuffer.position();
                this.chr = this.byteBuffer.get();
                if (this.chr == 32 || this.chr == 9) {
                    n4 = 1;
                    this.request.method().setBytes(this.byteBuffer.array(), this.parsingRequestLineStart, n3 - this.parsingRequestLineStart);
                    continue;
                }
                if (HttpParser.isToken(this.chr)) continue;
                this.request.protocol().setString("HTTP/1.1");
                String string = this.parseInvalid(this.parsingRequestLineStart, this.byteBuffer);
                throw new IllegalArgumentException(sm.getString("iib.invalidmethod", new Object[]{string}));
            }
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            n4 = 1;
            while (n4 != 0) {
                if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                    return false;
                }
                this.chr = this.byteBuffer.get();
                if (this.chr == 32 || this.chr == 9) continue;
                n4 = 0;
                this.byteBuffer.position(this.byteBuffer.position() - 1);
            }
            this.parsingRequestLineStart = this.byteBuffer.position();
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            n4 = 0;
            n3 = 0;
            while (n3 == 0) {
                if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                    return false;
                }
                int n5 = this.byteBuffer.position();
                this.prevChr = this.chr;
                this.chr = this.byteBuffer.get();
                if (this.prevChr == 13 && this.chr != 10) {
                    this.request.protocol().setString("HTTP/1.1");
                    String string = this.parseInvalid(this.parsingRequestLineStart, this.byteBuffer);
                    throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                }
                if (this.chr == 32 || this.chr == 9) {
                    n3 = 1;
                    n4 = n5;
                    continue;
                }
                if (this.chr == 13) continue;
                if (this.chr == 10) {
                    n3 = 1;
                    this.request.protocol().setString("");
                    this.parsingRequestLinePhase = 7;
                    if (this.prevChr == 13) {
                        n4 = n5 - 1;
                        continue;
                    }
                    n4 = n5;
                    continue;
                }
                if (this.chr == 63 && this.parsingRequestLineQPos == -1) {
                    this.parsingRequestLineQPos = n5;
                    continue;
                }
                if (this.parsingRequestLineQPos != -1 && !this.httpParser.isQueryRelaxed(this.chr)) {
                    this.request.protocol().setString("HTTP/1.1");
                    String string = this.parseInvalid(this.parsingRequestLineStart, this.byteBuffer);
                    throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                }
                if (!this.httpParser.isNotRequestTargetRelaxed(this.chr)) continue;
                this.request.protocol().setString("HTTP/1.1");
                String string = this.parseInvalid(this.parsingRequestLineStart, this.byteBuffer);
                throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
            }
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.byteBuffer.array(), this.parsingRequestLineQPos + 1, n4 - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.byteBuffer.array(), this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.byteBuffer.array(), this.parsingRequestLineStart, n4 - this.parsingRequestLineStart);
            }
            if (this.parsingRequestLinePhase == 4) {
                this.parsingRequestLinePhase = 5;
            }
        }
        if (this.parsingRequestLinePhase == 5) {
            n4 = 1;
            while (n4 != 0) {
                if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                    return false;
                }
                n3 = this.byteBuffer.get();
                if (n3 == 32 || n3 == 9) continue;
                n4 = 0;
                this.byteBuffer.position(this.byteBuffer.position() - 1);
            }
            this.parsingRequestLineStart = this.byteBuffer.position();
            this.parsingRequestLinePhase = 6;
            this.end = 0;
        }
        if (this.parsingRequestLinePhase == 6) {
            while (!this.parsingRequestLineEol) {
                if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                    return false;
                }
                n4 = this.byteBuffer.position();
                this.prevChr = this.chr;
                this.chr = this.byteBuffer.get();
                if (this.chr == 13) continue;
                if (this.prevChr == 13 && this.chr == 10) {
                    this.end = n4 - 1;
                    this.parsingRequestLineEol = true;
                    continue;
                }
                if (this.chr == 10) {
                    this.end = n4;
                    this.parsingRequestLineEol = true;
                    continue;
                }
                if (this.prevChr != 13 && HttpParser.isHttpProtocol(this.chr)) continue;
                String string = this.parseInvalid(this.parsingRequestLineStart, this.byteBuffer);
                throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol", new Object[]{string}));
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.byteBuffer.array(), this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
                this.parsingRequestLinePhase = 7;
            }
        }
        if (this.parsingRequestLinePhase == 7) {
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException(sm.getString("iib.invalidPhase", new Object[]{this.parsingRequestLinePhase}));
    }

    boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        HeaderParseStatus headerParseStatus = HeaderParseStatus.HAVE_MORE_HEADERS;
        do {
            headerParseStatus = this.parseHeader();
            if (this.byteBuffer.position() <= this.headerBufferSize && this.byteBuffer.capacity() - this.byteBuffer.position() >= this.socketReadBufferSize) continue;
            throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
        } while (headerParseStatus == HeaderParseStatus.HAVE_MORE_HEADERS);
        if (headerParseStatus == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.byteBuffer.position();
            return true;
        }
        return false;
    }

    int getParsingRequestLinePhase() {
        return this.parsingRequestLinePhase;
    }

    private String parseInvalid(int n, ByteBuffer byteBuffer) {
        int n2 = 0;
        while (byteBuffer.hasRemaining() && n2 != 32) {
            n2 = byteBuffer.get();
        }
        Object object = HeaderUtil.toPrintableString(byteBuffer.array(), byteBuffer.arrayOffset() + n, byteBuffer.position() - n);
        if (n2 != 32) {
            object = (String)object + "...";
        }
        return object;
    }

    void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int n = (int)this.activeFilters[this.lastActiveFilter].end();
            this.byteBuffer.position(this.byteBuffer.position() - n);
        }
    }

    @Override
    public int available() {
        return this.available(false);
    }

    int available(boolean bl) {
        int n = this.lastActiveFilter == -1 ? this.inputStreamInputBuffer.available() : this.activeFilters[this.lastActiveFilter].available();
        try {
            if (n == 0 && bl && !this.byteBuffer.hasRemaining() && this.wrapper.hasDataToRead()) {
                this.fill(false);
                n = this.byteBuffer.remaining();
            }
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("iib.available.readFail"), (Throwable)iOException);
            }
            n = 1;
        }
        return n;
    }

    boolean isFinished() {
        if (this.lastActiveFilter >= 0) {
            return this.activeFilters[this.lastActiveFilter].isFinished();
        }
        return false;
    }

    ByteBuffer getLeftover() {
        int n = this.byteBuffer.remaining();
        if (n > 0) {
            return ByteBuffer.wrap(this.byteBuffer.array(), this.byteBuffer.position(), n);
        }
        return null;
    }

    boolean isChunking() {
        for (int i = 0; i < this.lastActiveFilter; ++i) {
            if (this.activeFilters[i] != this.filterLibrary[1]) continue;
            return true;
        }
        return false;
    }

    void init(SocketWrapperBase<?> socketWrapperBase) {
        this.wrapper = socketWrapperBase;
        this.wrapper.setAppReadBufHandler(this);
        int n = this.headerBufferSize + this.wrapper.getSocketBufferHandler().getReadBuffer().capacity();
        if (this.byteBuffer == null || this.byteBuffer.capacity() < n) {
            this.byteBuffer = ByteBuffer.allocate(n);
            this.byteBuffer.position(0).limit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fill(boolean bl) throws IOException {
        int n;
        block15: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Before fill(): parsingHeader: [" + this.parsingHeader + "], parsingRequestLine: [" + this.parsingRequestLine + "], parsingRequestLinePhase: [" + this.parsingRequestLinePhase + "], parsingRequestLineStart: [" + this.parsingRequestLineStart + "], byteBuffer.position(): [" + this.byteBuffer.position() + "], byteBuffer.limit(): [" + this.byteBuffer.limit() + "], end: [" + this.end + "]"));
            }
            if (this.parsingHeader) {
                if (this.byteBuffer.limit() >= this.headerBufferSize) {
                    if (this.parsingRequestLine) {
                        this.request.protocol().setString("HTTP/1.1");
                    }
                    throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
                }
            } else {
                this.byteBuffer.limit(this.end).position(this.end);
            }
            n = -1;
            int n2 = this.byteBuffer.position();
            try {
                if (this.byteBuffer.position() < this.byteBuffer.limit()) {
                    this.byteBuffer.position(this.byteBuffer.limit());
                }
                this.byteBuffer.limit(this.byteBuffer.capacity());
                SocketWrapperBase<?> socketWrapperBase = this.wrapper;
                if (socketWrapperBase != null) {
                    n = socketWrapperBase.read(bl, this.byteBuffer);
                    break block15;
                }
                throw new CloseNowException(sm.getString("iib.eof.error"));
            }
            finally {
                if (this.byteBuffer.position() >= n2) {
                    this.byteBuffer.limit(this.byteBuffer.position());
                    this.byteBuffer.position(n2);
                } else {
                    this.byteBuffer.position(0);
                    this.byteBuffer.limit(0);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received [" + new String(this.byteBuffer.array(), this.byteBuffer.position(), this.byteBuffer.remaining(), StandardCharsets.ISO_8859_1) + "]"));
        }
        if (n > 0) {
            return true;
        }
        if (n == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return false;
    }

    private HeaderParseStatus parseHeader() throws IOException {
        int n;
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            this.prevChr = this.chr;
            this.chr = this.byteBuffer.get();
            if (this.chr == 13 && this.prevChr != 13) continue;
            if (this.chr == 10) {
                return HeaderParseStatus.DONE;
            }
            if (this.prevChr == 13) {
                this.byteBuffer.position(this.byteBuffer.position() - 2);
                break;
            }
            this.byteBuffer.position(this.byteBuffer.position() - 1);
            break;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.lineStart = this.headerData.start = this.byteBuffer.position();
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            n = this.byteBuffer.position();
            this.chr = this.byteBuffer.get();
            if (this.chr == 58) {
                if (this.headerData.start == n) {
                    return this.skipLine(false);
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
                this.headerData.headerValue = this.headers.addValue(this.byteBuffer.array(), this.headerData.start, n - this.headerData.start);
                this.headerData.start = n = this.byteBuffer.position();
                this.headerData.realPos = n;
                this.headerData.lastSignificantChar = n;
                break;
            }
            if (!HttpParser.isToken(this.chr)) {
                this.headerData.lastSignificantChar = n;
                this.byteBuffer.position(this.byteBuffer.position() - 1);
                return this.skipLine(false);
            }
            if (this.chr < 65 || this.chr > 90) continue;
            this.byteBuffer.put(n, (byte)(this.chr - -32));
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_SKIPLINE) {
            return this.skipLine(false);
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START || this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START) {
                do {
                    if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.chr = this.byteBuffer.get();
                } while (this.chr == 32 || this.chr == 9);
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
                this.byteBuffer.position(this.byteBuffer.position() - 1);
                this.chr = 0;
            }
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                n = 0;
                while (n == 0) {
                    if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.prevChr = this.chr;
                    this.chr = this.byteBuffer.get();
                    if (this.chr == 13 && this.prevChr != 13) continue;
                    if (this.chr == 10) {
                        n = 1;
                        continue;
                    }
                    if (this.prevChr == 13) {
                        return this.skipLine(true);
                    }
                    if (HttpParser.isControl(this.chr) && this.chr != 9) {
                        return this.skipLine(true);
                    }
                    if (this.chr == 32 || this.chr == 9) {
                        this.byteBuffer.put(this.headerData.realPos, this.chr);
                        ++this.headerData.realPos;
                        continue;
                    }
                    this.byteBuffer.put(this.headerData.realPos, this.chr);
                    this.headerData.lastSignificantChar = ++this.headerData.realPos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            n = this.byteBuffer.get(this.byteBuffer.position());
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (n != 32 && n != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                break;
            }
            this.byteBuffer.put(this.headerData.realPos, (byte)n);
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
        }
        this.headerData.headerValue.setBytes(this.byteBuffer.array(), this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    private HeaderParseStatus skipLine(boolean bl) throws IOException {
        boolean bl2 = this.rejectIllegalHeader;
        if (!bl2 && bl) {
            if (this.headers.getName(this.headers.size() - 1).equalsIgnoreCase("content-length")) {
                bl2 = true;
            } else {
                this.headers.removeHeader(this.headers.size() - 1);
            }
        }
        this.headerParsePos = HeaderParsePosition.HEADER_SKIPLINE;
        boolean bl3 = false;
        while (!bl3) {
            if (this.byteBuffer.position() >= this.byteBuffer.limit() && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            int n = this.byteBuffer.position();
            this.prevChr = this.chr;
            this.chr = this.byteBuffer.get();
            if (this.chr == 13) continue;
            if (this.chr == 10) {
                bl3 = true;
                continue;
            }
            this.headerData.lastSignificantChar = n;
        }
        if (bl2 || log.isDebugEnabled()) {
            if (bl2) {
                throw new IllegalArgumentException(sm.getString("iib.invalidheader.reject", new Object[]{HeaderUtil.toPrintableString(this.byteBuffer.array(), this.headerData.lineStart, this.headerData.lastSignificantChar - this.headerData.lineStart + 1)}));
            }
            log.debug((Object)sm.getString("iib.invalidheader", new Object[]{HeaderUtil.toPrintableString(this.byteBuffer.array(), this.headerData.lineStart, this.headerData.lastSignificantChar - this.headerData.lineStart + 1)}));
        }
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void expand(int n) {
        if (this.byteBuffer.capacity() >= n) {
            this.byteBuffer.limit(n);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put(this.byteBuffer);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.mark();
        byteBuffer = null;
    }

    private static class HeaderParseData {
        int lineStart = 0;
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        private HeaderParseData() {
        }

        public void recycle() {
            this.lineStart = 0;
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    private static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE_START,
        HEADER_VALUE,
        HEADER_MULTI_LINE,
        HEADER_SKIPLINE;

    }

    private class SocketInputBuffer
    implements InputBuffer {
        private SocketInputBuffer() {
        }

        @Override
        public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
            int n;
            if (Http11InputBuffer.this.byteBuffer.position() >= Http11InputBuffer.this.byteBuffer.limit()) {
                int n2 = n = Http11InputBuffer.this.request.getReadListener() == null ? 1 : 0;
                if (!Http11InputBuffer.this.fill(n != 0)) {
                    if (n != 0) {
                        return -1;
                    }
                    return 0;
                }
            }
            n = Http11InputBuffer.this.byteBuffer.remaining();
            applicationBufferHandler.setByteBuffer(Http11InputBuffer.this.byteBuffer.duplicate());
            Http11InputBuffer.this.byteBuffer.position(Http11InputBuffer.this.byteBuffer.limit());
            return n;
        }

        @Override
        public int available() {
            return Http11InputBuffer.this.byteBuffer.remaining();
        }
    }

    private static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

