/* Test totalorder.
   Copyright (C) 1997-2024 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_ff_i_data totalorder_test_data[] =
  {
    TEST_fpfp_b (totalorder, minus_zero, minus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, plus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, minus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, plus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, minus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, plus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, minus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, minus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, plus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, minus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_infty, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, plus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, minus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_infty, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, minus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, plus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, plus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, minus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, minus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, plus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, minus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, plus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, plus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, minus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, minus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, plus_infty, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, plus_infty, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, -qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, qnan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, -qnan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value, -snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value, -snan_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value, -snan_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, -min_subnorm_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, minus_zero, min_subnorm_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, -min_subnorm_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, plus_zero, min_subnorm_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -min_subnorm_value, minus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -min_subnorm_value, plus_zero, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, min_subnorm_value, minus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, min_subnorm_value, plus_zero, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, min_value, max_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, min_value, -max_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -min_value, max_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -min_value, -max_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, max_value, min_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, max_value, -min_value, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -max_value, min_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -max_value, -min_value, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x2"), qnan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x2"), qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x2"), qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x3fffff"), qnan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x3fffff"), qnan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x3fffff"), qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), -qnan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), -qnan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), -qnan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x2"), -qnan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x2"), -qnan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x2"), -qnan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x3fffff"), -qnan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x3fffff"), -qnan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x3fffff"), -qnan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x2"), qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x2"), qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x2"), qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x3fffff"), qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x3fffff"), qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x3fffff"), qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), -qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), -qnan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), -qnan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x2"), -qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x2"), -qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x2"), -qnan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x3fffff"), -qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x3fffff"), -qnan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x3fffff"), -qnan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x1"), snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x1"), snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x1"), snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x2"), snan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x2"), snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x2"), snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), snan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), snan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x1"), -snan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x1"), -snan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x1"), -snan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x2"), -snan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x2"), -snan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x2"), -snan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), -snan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), -snan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), -snan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x1"), snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x1"), snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x1"), snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x2"), snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x2"), snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x2"), snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x1"), -snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x1"), -snan_value_pl ("0x2"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x1"), -snan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x2"), -snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x2"), -snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x2"), -snan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), -snan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), -snan_value_pl ("0x2"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), -snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x3fffff"), qnan_value_pl ("0x1"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x3fffff"), -qnan_value_pl ("0x1"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x1"), snan_value_pl ("0x3fffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x1"), -snan_value_pl ("0x3fffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if PAYLOAD_DIG >= 34
    TEST_fpfp_b (totalorder, qnan_value_pl ("0xffffffff"), qnan_value_pl ("0x100000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0xffffffff"), -qnan_value_pl ("0x100000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x100000000"), qnan_value_pl ("0xffffffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x100000000"), -qnan_value_pl ("0xffffffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0xffffffff"), snan_value_pl ("0x100000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0xffffffff"), -snan_value_pl ("0x100000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x100000000"), snan_value_pl ("0xffffffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x100000000"), -snan_value_pl ("0xffffffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x100000000"), qnan_value_pl ("0x200000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x100000000"), -qnan_value_pl ("0x200000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x200000000"), qnan_value_pl ("0x100000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x200000000"), -qnan_value_pl ("0x100000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x100000000"), snan_value_pl ("0x200000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x100000000"), -snan_value_pl ("0x200000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x200000000"), snan_value_pl ("0x100000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x200000000"), -snan_value_pl ("0x100000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if PAYLOAD_DIG >= 66
    TEST_fpfp_b (totalorder, qnan_value_pl ("0xffffffffffffffff"), qnan_value_pl ("0x10000000000000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0xffffffffffffffff"), -qnan_value_pl ("0x10000000000000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x10000000000000000"), qnan_value_pl ("0xffffffffffffffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x10000000000000000"), -qnan_value_pl ("0xffffffffffffffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, snan_value_pl ("0xffffffffffffffff"), snan_value_pl ("0x10000000000000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0xffffffffffffffff"), -snan_value_pl ("0x10000000000000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x10000000000000000"), snan_value_pl ("0xffffffffffffffff"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x10000000000000000"), -snan_value_pl ("0xffffffffffffffff"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x10000000000000000"), qnan_value_pl ("0x20000000000000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x10000000000000000"), -qnan_value_pl ("0x20000000000000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, qnan_value_pl ("0x20000000000000000"), qnan_value_pl ("0x10000000000000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -qnan_value_pl ("0x20000000000000000"), -qnan_value_pl ("0x10000000000000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x10000000000000000"), snan_value_pl ("0x20000000000000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x10000000000000000"), -snan_value_pl ("0x20000000000000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, snan_value_pl ("0x20000000000000000"), snan_value_pl ("0x10000000000000000"), 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
    TEST_fpfp_b (totalorder, -snan_value_pl ("0x20000000000000000"), -snan_value_pl ("0x10000000000000000"), 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_FLOAT128_PAYLOAD),
#endif
    TEST_fpfp_b (totalorder, 1, 0x1.000002p0, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x1.000002p0, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, 0x0.ffffffp0, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x0.ffffffp0, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fpfp_b (totalorder, 1, 0x1.0000000000001p0, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x1.0000000000001p0, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, 0x0.fffffffffffff8p0, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x0.fffffffffffff8p0, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fpfp_b (totalorder, 1, 0x1.0000000000000002p0, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x1.0000000000000002p0, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, 0x0.ffffffffffffffffp0, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x0.ffffffffffffffffp0, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fpfp_b (totalorder, 1, 0x1.000000000000000000000000008p0, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x1.000000000000000000000000008p0, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, 0x0.ffffffffffffffffffffffffffcp0, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x0.ffffffffffffffffffffffffffcp0, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fpfp_b (totalorder, 1, 0x1.0000000000000000000000000001p0, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x1.0000000000000000000000000001p0, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 1, 0x0.ffffffffffffffffffffffffffff8p0, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fpfp_b (totalorder, 0x0.ffffffffffffffffffffffffffff8p0, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
  };

#ifndef COMPAT_TEST
static void
totalorder_test (void)
{
  ALL_RM_TEST (totalorder, 1, totalorder_test_data, RUN_TEST_LOOP_fpfp_b, END);
}

static void
do_test (void)
{
  totalorder_test ();
}
#endif

/*
 * Local Variables:
 * mode:c
 * End:
 */
