.TH setpci 8 "@TODAY@" "@VERSION@" "The PCI Utilities"
.SH NAME
setpci \- configure PCI devices
.SH SYNOPSIS
.B setpci
.RB [ options ]
.B devices
.BR operations ...

.SH DESCRIPTION
.PP
.B setpci
is a utility for querying and configuring PCI devices.

All numbers are entered in hexadecimal notation.

Root privileges are necessary for almost all operations, excluding reads
of the standard header of the configuration space on some operating systems.
Please see
.BR lspci(8)
for details on access rights.

.SH OPTIONS

.SS General options
.TP
.B -v
Tells
.I setpci
to be verbose and display detailed information about configuration space accesses.
.TP
.B -f
Tells
.I setpci
not to complain when there's nothing to do (when no devices are selected).
This option is intended for use in widely-distributed configuration scripts
where it's uncertain whether the device in question is present in the machine
or not.
.TP
.B -D
`Demo mode' -- don't write anything to the configuration registers.
It's useful to try
.B setpci -vD
to verify that your complex sequence of
.B setpci
operations does what you think it should do.
.TP
.B -r
Avoids bus scan if each operation selects a specific device (uses the
.B -s
selector with specific domain, bus, slot, and function). This is faster,
but if the device does not exist, it fails instead of matching an empty
set of devices.
.TP
.B --version
Show
.I setpci
version. This option should be used stand-alone.
.TP
.B --help
Show detailed help on available options. This option should be used stand-alone.
.TP
.B --dumpregs
Show a list of all known PCI registers and capabilities. This option should be
used stand-alone.

.SS PCI access options
.PP
The PCI utilities use the PCI library to talk to PCI devices (see
\fBpcilib\fP(7) for details). You can use the following options to
influence its behavior:
.TP
.B -A <method>
The library supports a variety of methods to access the PCI hardware.
By default, it uses the first access method available, but you can use
this option to override this decision. See \fB-A help\fP for a list of
available methods and their descriptions.
.TP
.B -O <param>=<value>
The behavior of the library is controlled by several named parameters.
This option allows to set the value of any of the parameters. Use \fB-O help\fP
for a list of known parameters and their default values.
.TP
.B -H1
Use direct hardware access via Intel configuration mechanism 1.
(This is a shorthand for \fB-A intel-conf1\fP.)
.TP
.B -H2
Use direct hardware access via Intel configuration mechanism 2.
(This is a shorthand for \fB-A intel-conf2\fP.)
.TP
.B -G
Increase debug level of the library.

.SH DEVICE SELECTION
.PP
Before each sequence of operations you need to select which devices you wish that
operation to affect.
.TP
.B -s [[[[<domain>]:]<bus>]:][<slot>][.[<func>]]
Consider only devices in the specified domain (in case your machine has several host bridges,
they can either share a common bus number space or each of them can address a PCI domain
of its own; domains are numbered from 0 to ffff), bus (0 to ff), slot (0 to 1f) and function (0 to 7).
Each component of the device address can be omitted or set to "*", both meaning "any value". All numbers are
hexadecimal.  E.g., "0:" means all devices on bus 0, "0" means all functions of device 0
on any bus, "0.3" selects third function of device 0 on all buses and ".4" matches only
the fourth function of each device.
.TP
.B -d [<vendor>]:[<device>]
Select devices with specified vendor and device ID. Both ID's are given in
hexadecimal and may be omitted or given as "*", both meaning "any value".
.PP
When
.B -s
and
.B -d
are combined, only devices that match both criteria are selected. When multiple
options of the same kind are specified, the rightmost one overrides the others.

.SH OPERATIONS
.PP
There are two kinds of operations: reads and writes. To read a register, just specify
its name. Writes have the form
.IR name = value , value ...\&
where each
.I value
is either a hexadecimal number or an expression of type
.IR data : mask
where both
.I data
and
.I mask
are hexadecimal numbers. In the latter case, only the bits corresponding to binary
ones in the \fImask\fP are changed (technically, this is a read-modify-write operation).

.PP
There are several ways how to identity a register:
.IP \(bu
Tell its address in hexadecimal.
.IP \(bu
Spell its name. Setpci knows the names of all registers in the standard configuration
headers. Use `\fBsetpci --dumpregs\fP' to get the complete list.
See PCI bus specifications for the precise meaning of these registers or consult
\fBheader.h\fP or \fB/usr/include/pci/pci.h\fP for a brief sketch.
.IP \(bu
If the register is a part of a PCI capability, you can specify the name of the
capability to get the address of its first register. See the names starting with
`CAP_' or `ECAP_' in the \fB--dumpregs\fP output.
.IP \(bu
If the name of the capability is not known to \fBsetpci\fP, you can refer to it
by its number in the form CAP\fBid\fP or ECAP\fBid\fP, where \fBid\fP is the numeric
identifier of the capability in hexadecimal.
.IP \(bu
Each of the previous formats can be followed by \fB+offset\fP to add an offset
(a hex number) to the address. This feature can be useful for addressing of registers
living within a capability, or to modify parts of standard registers.
.IP \(bu
To choose how many bytes (1, 2, or 4) should be transferred, you should append a width
specifier \fB.B\fP, \fB.W\fP, or \fB.L\fP. The width can be omitted if you are
referring to a register by its name and the width of the register is well known.
.IP \(bu
Finally, if a capability exists multiple times you can choose which one to target using
\fB@number\fP. Indexing starts at 0.

.PP
All names of registers and width specifiers are case-insensitive.

.SH
EXAMPLES

.IP COMMAND
asks for the word-sized command register.
.IP 4.w
is a numeric address of the same register.
.IP COMMAND.l
asks for a 32-bit word starting at the location of the command register,
i.e., the command and status registers together.
.IP VENDOR_ID+1.b
specifies the upper byte of the vendor ID register (remember, PCI is little-endian).
.IP CAP_PM+2.w
corresponds to the second word of the power management capability.
.IP ECAP108.l
asks for the first 32-bit word of the extended capability with ID 0x108.

.SH SEE ALSO
.BR lspci (8),
.BR pcilib (7)

.SH AUTHOR
The PCI Utilities are maintained by Martin Mares <mj@ucw.cz>.
