"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const vue = require("@vue/language-core");
const twoslashReg = /<!--\s*\^\?\s*-->/g;
function create(ts, getTsPluginClient) {
    return {
        name: 'vue-twoslash-queries',
        create(context) {
            const tsPluginClient = getTsPluginClient?.(context);
            return {
                async provideInlayHints(document, range) {
                    const decoded = context.decodeEmbeddedDocumentUri(document.uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!(sourceScript?.generated?.root instanceof vue.VueVirtualCode) || virtualCode?.id !== 'template') {
                        return;
                    }
                    const hoverOffsets = [];
                    const inlayHints = [];
                    for (const pointer of document.getText(range).matchAll(twoslashReg)) {
                        const offset = pointer.index + pointer[0].indexOf('^?') + document.offsetAt(range.start);
                        const position = document.positionAt(offset);
                        hoverOffsets.push([position, document.offsetAt({
                                line: position.line - 1,
                                character: position.character,
                            })]);
                    }
                    for (const [pointerPosition, hoverOffset] of hoverOffsets) {
                        for (const [_1, [_2, map]] of context.language.maps.forEach(virtualCode)) {
                            for (const [sourceOffset] of map.getSourceOffsets(hoverOffset)) {
                                const quickInfo = await tsPluginClient?.getQuickInfoAtPosition(sourceScript.generated.root.fileName, sourceOffset);
                                if (quickInfo) {
                                    inlayHints.push({
                                        position: { line: pointerPosition.line, character: pointerPosition.character + 2 },
                                        label: ts.displayPartsToString(quickInfo.displayParts),
                                        paddingLeft: true,
                                        paddingRight: false,
                                    });
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    return inlayHints;
                },
            };
        },
    };
}
exports.create = create;
//# sourceMappingURL=vue-twoslash-queries.js.map