import type { AttrNameCasing, SFCParseResult, TagNameCasing } from '@vue/language-service';
import * as vscode from 'vscode-languageserver-protocol';
export declare namespace DetectNameCasingRequest {
    type ParamsType = {
        textDocument: vscode.TextDocumentIdentifier;
    };
    type ResponseType = {
        tag: TagNameCasing[];
        attr: AttrNameCasing[];
    } | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace GetConvertTagCasingEditsRequest {
    type ParamsType = {
        textDocument: vscode.TextDocumentIdentifier;
        casing: TagNameCasing;
    };
    type ResponseType = vscode.TextEdit[] | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace GetConvertAttrCasingEditsRequest {
    type ParamsType = {
        textDocument: vscode.TextDocumentIdentifier;
        casing: AttrNameCasing;
    };
    type ResponseType = vscode.TextEdit[] | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace ParseSFCRequest {
    type ParamsType = string;
    type ResponseType = SFCParseResult;
    type ErrorType = never;
    const type: vscode.RequestType<string, SFCParseResult, never>;
}
export declare namespace GetConnectedNamedPipeServerRequest {
    type ParamsType = string;
    type ResponseType = {
        path: string;
        serverKind: number;
    } | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<string, ResponseType, never>;
}
