/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.hover.FocusableBrowserInformationControl;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class LSPTextHover
implements ITextHover,
ITextHoverExtension {
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage(true));
    private static final int GET_TIMEOUT_MS = 1000;
    private IRegion lastRegion;
    private ITextViewer lastViewer;
    private CompletableFuture<@NonNull List<@NonNull Hover>> request;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        CompletableFuture<String> hoverInfoFuture = this.getHoverInfoFuture(textViewer, hoverRegion);
        if (hoverInfoFuture != null) {
            try {
                String result = hoverInfoFuture.get(1000L, TimeUnit.MILLISECONDS);
                if (result != null) {
                    return result;
                }
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get hover information due to timeout after 1000 milliseconds", e);
            }
        }
        return null;
    }

    public CompletableFuture<String> getHoverInfoFuture(@NonNull ITextViewer textViewer, @NonNull IRegion hoverRegion) {
        if (this.request == null || !textViewer.equals(this.lastViewer) || !hoverRegion.equals(this.lastRegion)) {
            this.initiateHoverRequest(textViewer, hoverRegion.getOffset());
        }
        return this.request.thenApply(hoversList -> {
            String result = hoversList.stream().filter(Objects::nonNull).map(LSPTextHover::getHoverString).filter(Objects::nonNull).collect(Collectors.joining("\n\n")).trim();
            if (!result.isEmpty()) {
                return MARKDOWN_PARSER.parseToHtml(result);
            }
            return null;
        });
    }

    protected static @Nullable String getHoverString(@NonNull Hover hover) {
        Either hoverContent = hover.getContents();
        if (hoverContent.isLeft()) {
            List contents = (List)hoverContent.getLeft();
            if (contents == null || contents.isEmpty()) {
                return null;
            }
            return contents.stream().map(content -> {
                if (content.isLeft()) {
                    return (String)content.getLeft();
                }
                if (content.isRight()) {
                    MarkedString markedString = (MarkedString)content.getRight();
                    if (markedString.getLanguage() != null && !markedString.getLanguage().isEmpty()) {
                        return String.format("```%s%n%s%n```", markedString.getLanguage(), markedString.getValue());
                    }
                    return markedString.getValue();
                }
                return "";
            }).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.joining("\n\n"));
        }
        return ((MarkupContent)hoverContent.getRight()).getValue();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null) {
            return null;
        }
        if (this.request == null || this.lastRegion == null || !textViewer.equals(this.lastViewer) || offset < this.lastRegion.getOffset() || offset > this.lastRegion.getOffset() + this.lastRegion.getLength()) {
            this.initiateHoverRequest(textViewer, offset);
        }
        try {
            IDocument document = textViewer.getDocument();
            boolean[] oneHoverAtLeast = new boolean[1];
            int[] regionStartOffset = new int[1];
            int[] regionEndOffset = new int[]{document.getLength()};
            this.request.get(1000L, TimeUnit.MILLISECONDS).stream().filter(Objects::nonNull).map(Hover::getRange).filter(Objects::nonNull).forEach(range -> {
                try {
                    nArray[0] = Math.max(regionStartOffset[0], LSPEclipseUtils.toOffset(range.getStart(), document));
                    nArray2[0] = Math.min(regionEndOffset[0], LSPEclipseUtils.toOffset(range.getEnd(), document));
                    blArray[0] = true;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            });
            if (oneHoverAtLeast[0]) {
                this.lastRegion = new Region(regionStartOffset[0], regionEndOffset[0] - regionStartOffset[0]);
                return this.lastRegion;
            }
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not get hover region due to timeout after 1000 milliseconds", e);
        }
        this.lastRegion = new Region(offset, 0);
        return this.lastRegion;
    }

    private void initiateHoverRequest(@NonNull ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        this.lastViewer = viewer;
        try {
            HoverParams params = LSPEclipseUtils.toHoverParams(offset, document);
            this.request = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(server -> server.getTextDocumentService().hover(params));
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }
}

