/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.JsonParserWithStringSubstitution;
import org.eclipse.lsp4e.debug.debugmodel.TransportStreams;
import org.eclipse.osgi.util.NLS;

public class DSPLaunchDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
        builder.launchNotConnect = "launch server".equals(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server"));
        builder.debugCmd = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", null);
        builder.debugCmdArgs = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", null);
        builder.debugCmdEnvVars = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        builder.monitorDebugAdapter = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false);
        builder.server = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", null);
        builder.port = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 0);
        String dspParametersJson = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", null);
        try {
            JsonParserWithStringSubstitution jsonUtils = new JsonParserWithStringSubstitution(VariablesPlugin.getDefault().getStringVariableManager());
            Map<String, Object> customParams = jsonUtils.parseJsonObject(dspParametersJson);
            builder.dspParameters.putAll(customParams);
        }
        catch (IllegalStateException e) {
            this.abort("Json launch parameters were not correctly formatted.", e);
        }
        this.launch(builder);
    }

    public void launch(DSPLaunchDelegateLaunchBuilder builderSrc) throws CoreException {
        DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegateLaunchBuilder(builderSrc);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)builder.monitor, (int)100);
        builder.dspParameters = new HashMap<String, Object>(builder.dspParameters);
        boolean customDebugAdapter = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_DEBUG_ADAPTER", false);
        boolean customLaunchParameters = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_LAUNCH_PARAMS", false);
        if (customDebugAdapter) {
            builder.launchNotConnect = "launch server".equals(builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server"));
            builder.debugCmd = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", null);
            builder.debugCmdArgs = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", null);
            builder.debugCmdEnvVars = DebugPlugin.getDefault().getLaunchManager().getEnvironment(builder.configuration);
            builder.monitorDebugAdapter = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false);
            builder.server = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", null);
            builder.port = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 0);
        }
        if (customLaunchParameters) {
            String dspParametersJson = builder.configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", null);
            try {
                JsonParserWithStringSubstitution jsonUtils = new JsonParserWithStringSubstitution(VariablesPlugin.getDefault().getStringVariableManager());
                Map<String, Object> customParams = jsonUtils.parseJsonObject(dspParametersJson);
                builder.dspParameters.putAll(customParams);
            }
            catch (IllegalStateException | CoreException e) {
                this.abort("Json launch parameters were not correctly formatted.", e);
            }
        }
        if ("debug".equals(builder.mode)) {
            subMonitor.setTaskName("Starting debug session");
            builder.dspParameters.put("noDebug", false);
        } else if ("run".equals(builder.mode)) {
            subMonitor.setTaskName("Starting run session");
            builder.dspParameters.put("noDebug", true);
        } else {
            this.abort(NLS.bind((String)"Unsupported launch mode '{0}'.", (Object)builder.mode), null);
        }
        try {
            try {
                Supplier<TransportStreams> streamSupplier;
                if (builder.launchNotConnect) {
                    Runnable cleanup;
                    OutputStream outputStream;
                    InputStream inputStream;
                    ArrayList<String> command = new ArrayList<String>();
                    if (builder.debugCmd == null) {
                        this.abort("Debug command unspecified.", null);
                    }
                    command.add(builder.debugCmd);
                    if (builder.debugCmdArgs != null && !builder.debugCmdArgs.isEmpty()) {
                        command.addAll(builder.debugCmdArgs);
                    }
                    subMonitor.subTask(NLS.bind((String)"Launching debug adapter: {0}", (Object)("\"" + String.join((CharSequence)"\" \"", command) + "\"")));
                    final Process debugAdapterProcess = DebugPlugin.exec((String[])((String[])command.toArray(String[]::new)), null, (String[])builder.debugCmdEnvVars);
                    if (builder.monitorDebugAdapter) {
                        String initialCaptureOutput = builder.launch.getAttribute("org.eclipse.debug.core.capture_output");
                        builder.launch.setAttribute("org.eclipse.debug.core.capture_output", Boolean.toString(true));
                        final IProcess debugAdapterIProcess = DebugPlugin.newProcess((ILaunch)builder.launch, (Process)debugAdapterProcess, (String)"Debug Adapter");
                        builder.launch.setAttribute("org.eclipse.debug.core.capture_output", initialCaptureOutput);
                        final List bytes = Collections.synchronizedList(new LinkedList());
                        inputStream = new InputStream(){

                            @Override
                            public int read() throws IOException {
                                while (debugAdapterProcess.isAlive()) {
                                    if (!bytes.isEmpty()) {
                                        return ((Byte)bytes.remove(0)).byteValue();
                                    }
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                        DSPPlugin.logError(e);
                                    }
                                }
                                return -1;
                            }
                        };
                        DSPLaunchDelegateLaunchBuilder finalBuilder = builder;
                        debugAdapterIProcess.getStreamsProxy().getOutputStreamMonitor().addListener((text, monitor) -> {
                            try {
                                byte[] byArray = text.getBytes(dSPLaunchDelegateLaunchBuilder.launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING"));
                                int n = byArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    byte b = byArray[n2];
                                    bytes.add(b);
                                    ++n2;
                                }
                            }
                            catch (IOException e) {
                                DSPPlugin.logError(e);
                            }
                        });
                        outputStream = new OutputStream(){

                            @Override
                            public void write(int b) throws IOException {
                                debugAdapterIProcess.getStreamsProxy().write(new String(new byte[]{(byte)b}));
                            }
                        };
                        cleanup = () -> {
                            try {
                                debugAdapterIProcess.terminate();
                                debugAdapterProcess.destroy();
                            }
                            catch (DebugException e) {
                                DSPPlugin.logError(e);
                            }
                        };
                    } else {
                        inputStream = debugAdapterProcess.getInputStream();
                        outputStream = debugAdapterProcess.getOutputStream();
                        cleanup = debugAdapterProcess::destroyForcibly;
                    }
                    streamSupplier = () -> new TransportStreams.DefaultTransportStreams(inputStream, outputStream){

                        @Override
                        public void close() {
                            super.close();
                            cleanup.run();
                        }
                    };
                } else {
                    if (builder.server == null) {
                        this.abort("Debug server host unspecified.", null);
                    }
                    if (builder.port < 1 || builder.port > 65535) {
                        this.abort("Debug server port unspecified or out of range 1-65535.", null);
                    }
                    subMonitor.subTask(NLS.bind((String)"Connecting to debug adapter: {0}:{1}", (Object)builder.server, (Object)builder.port));
                    streamSupplier = () -> new TransportStreams.SocketTransportStreams(dSPLaunchDelegateLaunchBuilder.server, dSPLaunchDelegateLaunchBuilder.port);
                }
                subMonitor.setWorkRemaining(80);
                ILaunch launch = builder.launch;
                Map<String, Object> dspParameters = builder.dspParameters;
                IDebugTarget target = this.createDebugTarget(subMonitor, streamSupplier, launch, dspParameters);
                builder.launch.addDebugTarget(target);
            }
            catch (OperationCanceledException e1) {
                this.abort("Failed to start debugging", e1);
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected IDebugTarget createDebugTarget(SubMonitor subMonitor, Supplier<TransportStreams> streamsSupplier, ILaunch launch, Map<String, Object> dspParameters) throws CoreException {
        DSPDebugTarget target = new DSPDebugTarget(launch, streamsSupplier, dspParameters);
        target.initialize((IProgressMonitor)subMonitor.split(80));
        return target;
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e.debug", 0, message, e));
    }

    public static class DSPLaunchDelegateLaunchBuilder {
        ILaunchConfiguration configuration;
        String mode;
        ILaunch launch;
        IProgressMonitor monitor;
        boolean launchNotConnect;
        String debugCmd;
        List<String> debugCmdArgs;
        String[] debugCmdEnvVars;
        boolean monitorDebugAdapter;
        String server;
        int port;
        Map<String, Object> dspParameters;

        private DSPLaunchDelegateLaunchBuilder(DSPLaunchDelegateLaunchBuilder other) {
            this.configuration = other.configuration;
            this.mode = other.mode;
            this.launch = other.launch;
            this.monitor = other.monitor;
            this.launchNotConnect = other.launchNotConnect;
            this.debugCmd = other.debugCmd;
            this.debugCmdArgs = other.debugCmdArgs == null ? null : new ArrayList<String>(other.debugCmdArgs);
            this.monitorDebugAdapter = other.monitorDebugAdapter;
            this.server = other.server;
            this.port = other.port;
            this.dspParameters = new HashMap<String, Object>(other.dspParameters);
        }

        public DSPLaunchDelegateLaunchBuilder(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
            this.configuration = configuration;
            this.mode = mode;
            this.launch = launch;
            this.monitor = monitor;
        }

        public DSPLaunchDelegateLaunchBuilder setLaunchDebugAdapter(String debugCmd, List<String> debugCmdArgs) {
            return this.setLaunchDebugAdapter(debugCmd, debugCmdArgs, (String[])null);
        }

        public DSPLaunchDelegateLaunchBuilder setLaunchDebugAdapter(String debugCmd, List<String> debugCmdArgs, Map<String, String> envVars) {
            return this.setLaunchDebugAdapter(debugCmd, debugCmdArgs, envVars == null ? null : (String[])envVars.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + (String)e.getValue()).toArray(String[]::new));
        }

        public DSPLaunchDelegateLaunchBuilder setLaunchDebugAdapter(String debugCmd, List<String> debugCmdArgs, String[] envVars) {
            this.launchNotConnect = true;
            this.debugCmd = debugCmd;
            this.debugCmdArgs = debugCmdArgs;
            this.debugCmdEnvVars = envVars;
            return this;
        }

        public DSPLaunchDelegateLaunchBuilder setAttachDebugAdapter(String server, int port) {
            this.launchNotConnect = false;
            this.server = server;
            this.port = port;
            return this;
        }

        public DSPLaunchDelegateLaunchBuilder setMonitorDebugAdapter(boolean monitorDebugAdapter) {
            this.monitorDebugAdapter = monitorDebugAdapter;
            return this;
        }

        public DSPLaunchDelegateLaunchBuilder setDspParameters(Map<String, Object> dspParameters) {
            this.dspParameters = dspParameters;
            return this;
        }

        public ILaunchConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getMode() {
            return this.mode;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public IProgressMonitor getMonitor() {
            return this.monitor;
        }

        public boolean isLaunchNotConnect() {
            return this.launchNotConnect;
        }

        public String getDebugCmd() {
            return this.debugCmd;
        }

        public List<String> getDebugCmdArgs() {
            return this.debugCmdArgs;
        }

        public String[] getDebugCmdEnvVars() {
            return this.debugCmdEnvVars;
        }

        public boolean isMonitorDebugAdapter() {
            return this.monitorDebugAdapter;
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public Map<String, Object> getDspParameters() {
            return this.dspParameters;
        }

        public String toString() {
            return "DSPLaunchDelegateLaunchBuilder [configuration=" + this.configuration + ", mode=" + this.mode + ", launch=" + this.launch + ", monitor=" + this.monitor + ", launchNotConnect=" + this.launchNotConnect + ", debugCmd=" + this.debugCmd + ", debugCmdArgs=" + this.debugCmdArgs + ", debugCmdEnvVars=" + List.of(this.debugCmdEnvVars) + ", monitorDebugAdapter=" + this.monitorDebugAdapter + ", server=" + this.server + ", port=" + this.port + ", dspParameters=" + this.dspParameters + "]";
        }
    }
}

