"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.startLanguageServer = exports.createConnection = void 0;
const vscode = require("vscode-languageserver/browser");
const server_1 = require("../common/server");
const http_1 = require("../common/schemaRequestHandlers/http");
const vscode_uri_1 = require("vscode-uri");
const protocol_1 = require("../protocol");
__exportStar(require("../index"), exports);
function createConnection() {
    const messageReader = new vscode.BrowserMessageReader(self);
    const messageWriter = new vscode.BrowserMessageWriter(self);
    const connection = vscode.createConnection(messageReader, messageWriter);
    return connection;
}
exports.createConnection = createConnection;
function startLanguageServer(connection, ...plugins) {
    (0, server_1.startCommonLanguageServer)(connection, plugins, () => ({
        uriToFileName,
        fileNameToUri,
        timer: {
            setImmediate(callback, ...args) {
                const handle = setTimeout(callback, 0, ...args);
                return { dispose: () => clearTimeout(handle) };
            },
        },
        loadTypescript() {
            return require('typescript'); // force bundle because not support load by user config in web
        },
        async loadTypescriptLocalized(tsdk, locale) {
            try {
                const uri = fileNameToUri(`${tsdk}/${locale}/diagnosticMessages.generated.json`);
                const json = await (0, http_1.default)(uri);
                if (json) {
                    return JSON.parse(json);
                }
            }
            catch { }
        },
        fs: {
            stat(uri) {
                return connection.sendRequest(protocol_1.FsStatRequest.type, uri);
            },
            async readFile(uri, encoding) {
                const data = await connection.sendRequest(protocol_1.FsReadFileRequest.type, uri);
                if (data) {
                    return new TextDecoder(encoding ?? 'utf8').decode(data);
                }
                if (uri.startsWith('http://') || uri.startsWith('https://')) {
                    return await (0, http_1.default)(uri);
                }
            },
            async readDirectory(uri) {
                return connection.sendRequest(protocol_1.FsReadDirectoryRequest.type, uri);
            },
        },
    }));
}
exports.startLanguageServer = startLanguageServer;
function uriToFileName(uri) {
    const parsed = vscode_uri_1.URI.parse(uri);
    return `/${parsed.scheme}${parsed.authority ? '@' + parsed.authority : ''}${parsed.path}`;
}
;
function fileNameToUri(fileName) {
    const parts = fileName.split('/');
    if (parts.length <= 1) {
        return vscode_uri_1.URI.from({ scheme: '', path: '' }).toString();
    }
    const firstParts = parts[1].split('@');
    return vscode_uri_1.URI.from({
        scheme: firstParts[0],
        authority: firstParts.length > 1 ? firstParts[1] : undefined,
        path: '/' + parts.slice(2).join('/'),
    }).toString();
}
;
//# sourceMappingURL=index.js.map