/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnvironmentVariablesPromptDialog
extends SystemPromptDialog
implements ModifyListener {
    private Text nameTextField;
    private Text valueTextField;
    private String name;
    private String value;
    private String invalidNameChars;
    private IRSESystemType systemType;
    private boolean change;
    private String[] existingNames;

    public EnvironmentVariablesPromptDialog(Shell shell, String title, IRSESystemType systemType, String invalidNameChars, String[] existingNames, boolean change) {
        super(shell, title);
        this.change = change;
        this.systemType = systemType;
        this.invalidNameChars = invalidNameChars;
        this.existingNames = existingNames;
    }

    public EnvironmentVariablesPromptDialog(Shell shell, String title, Object inputObject, String invalidNameChars, String[] existingNames, boolean change) {
        super(shell, title, inputObject);
        this.change = change;
        this.invalidNameChars = invalidNameChars;
        this.existingNames = existingNames;
    }

    protected Control createInner(Composite parent) {
        Composite page = SystemWidgetHelpers.createComposite(parent, 2);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_SUBSYSTEM_ENVVAR_NAME_LABEL);
        this.nameTextField = SystemWidgetHelpers.createTextField(page, null);
        ((GridData)this.nameTextField.getLayoutData()).widthHint = 500;
        this.nameTextField.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_NAME_TOOLTIP);
        if (this.name != null && !this.name.trim().equals("")) {
            this.nameTextField.setText(this.name);
            this.setInitialOKButtonEnabledState(true);
        } else {
            this.setInitialOKButtonEnabledState(false);
        }
        this.nameTextField.addModifyListener((ModifyListener)this);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_SUBSYSTEM_ENVVAR_VALUE_LABEL);
        this.valueTextField = SystemWidgetHelpers.createTextField(page, null);
        ((GridData)this.valueTextField.getLayoutData()).widthHint = 500;
        this.valueTextField.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_VALUE_TOOLTIP);
        if (this.value != null) {
            this.valueTextField.setText(this.value);
        }
        if (!this.change) {
            SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.envv0001");
        } else {
            SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.envv0002");
        }
        if (this.systemType != null) {
            if (this.systemType.getId().equals("org.eclipse.rse.systemtype.iseries")) {
                this.nameTextField.setTextLimit(128);
                this.valueTextField.setTextLimit(1024);
            } else if (this.systemType.isWindows()) {
                this.nameTextField.setTextLimit(300);
                this.valueTextField.setTextLimit(1024);
            }
        }
        return parent;
    }

    protected Control getInitialFocusControl() {
        return this.nameTextField;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected boolean processOK() {
        if (this.nameTextField.getText() != null && !this.nameTextField.getText().trim().equals("")) {
            int i;
            String nameStr = this.invalidNameChars != null && this.invalidNameChars.indexOf(32) != -1 ? this.nameTextField.getText().trim() : this.nameTextField.getText();
            if (this.invalidNameChars != null) {
                i = 0;
                while (i < this.invalidNameChars.length()) {
                    if (nameStr.indexOf(this.invalidNameChars.charAt(i)) != -1) {
                        this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2004"));
                        this.nameTextField.setFocus();
                        return false;
                    }
                    ++i;
                }
            }
            if (this.existingNames != null) {
                i = 0;
                while (i < this.existingNames.length) {
                    if (!(!nameStr.equals(this.existingNames[i]) || this.change && nameStr.equals(this.name))) {
                        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC2001");
                        msg.makeSubstitution((Object)nameStr);
                        this.setErrorMessage(msg);
                        this.nameTextField.setFocus();
                        return false;
                    }
                    ++i;
                }
            }
            this.name = nameStr;
            this.value = this.valueTextField.getText();
            return true;
        }
        this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2002"));
        this.nameTextField.setFocus();
        return false;
    }

    public void modifyText(ModifyEvent e) {
        if (this.nameTextField.getText().trim().equals("")) {
            this.enableOkButton(false);
        } else {
            this.enableOkButton(true);
        }
    }
}

