/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.folding;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class LSPFoldingReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IProjectionListener {
    private IDocument document;
    private ProjectionAnnotationModel projectionAnnotationModel;
    private ProjectionViewer viewer;

    public void reconcile(IRegion subRegion) {
        if (this.projectionAnnotationModel == null || this.document == null) {
            return;
        }
        URI uri = LSPEclipseUtils.toUri(this.document);
        if (uri == null) {
            return;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri.toString());
        FoldingRangeRequestParams params = new FoldingRangeRequestParams(identifier);
        LanguageServiceAccessor.getLanguageServers(this.document, LSPFoldingReconcilingStrategy::canFold).thenAcceptAsync(servers -> {
            if (servers.isEmpty()) {
                return;
            }
            servers.stream().forEach(server -> server.getTextDocumentService().foldingRange(params).thenAcceptAsync(this::applyFolding));
        });
    }

    private void applyFolding(List<FoldingRange> ranges) {
        ArrayList<Annotation> modifications = new ArrayList<Annotation>();
        ArrayList<FoldingAnnotation> deletions = new ArrayList<FoldingAnnotation>();
        ArrayList<FoldingAnnotation> existing = new ArrayList<FoldingAnnotation>();
        HashMap<Annotation, Position> additions = new HashMap<Annotation, Position>();
        this.markInvalidAnnotationsForDeletion(deletions, existing);
        try {
            if (ranges != null) {
                Collections.sort(ranges, Comparator.comparing(FoldingRange::getEndLine));
                for (FoldingRange foldingRange : ranges) {
                    this.updateAnnotation(modifications, deletions, existing, additions, foldingRange.getStartLine(), foldingRange.getEndLine());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.projectionAnnotationModel != null) {
            if (!existing.isEmpty()) {
                deletions.addAll(existing);
            }
            this.projectionAnnotationModel.modifyAnnotations(deletions.toArray(new Annotation[1]), additions, modifications.toArray(new Annotation[0]));
        }
    }

    private static boolean canFold(ServerCapabilities capabilities) {
        return capabilities.getFoldingRangeProvider() != null && (capabilities.getFoldingRangeProvider().getLeft() != null && (Boolean)capabilities.getFoldingRangeProvider().getLeft() != false || capabilities.getFoldingRangeProvider().getRight() != null);
    }

    public void install(ProjectionViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
        }
        this.viewer = viewer;
        this.viewer.addProjectionListener((IProjectionListener)this);
        this.projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
            this.viewer = null;
        }
        this.projectionDisabled();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void projectionDisabled() {
        this.projectionAnnotationModel = null;
    }

    public void projectionEnabled() {
        if (this.viewer != null) {
            this.projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
        }
    }

    private void updateAnnotation(List<Annotation> modifications, List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing, Map<Annotation, Position> additions, int line, Integer endLineNumber) throws BadLocationException {
        int startOffset = this.document.getLineOffset(line);
        int endOffset = this.document.getLineOffset(endLineNumber.intValue()) + this.document.getLineLength(endLineNumber.intValue());
        Position newPos = new Position(startOffset, endOffset - startOffset);
        if (!existing.isEmpty()) {
            FoldingAnnotation existingAnnotation = existing.remove(existing.size() - 1);
            this.updateAnnotations((Annotation)existingAnnotation, newPos, modifications, deletions);
        } else {
            additions.put((Annotation)new FoldingAnnotation(false), newPos);
        }
    }

    protected void updateAnnotations(Annotation existingAnnotation, Position newPos, List<Annotation> modifications, List<FoldingAnnotation> deletions) {
        if (existingAnnotation instanceof FoldingAnnotation var5_6) {
            if (newPos != null && newPos.length > 0 && this.projectionAnnotationModel != null) {
                Position oldPos = this.projectionAnnotationModel.getPosition((Annotation)foldingAnnotation);
                if (!newPos.equals((Object)oldPos)) {
                    oldPos.setOffset(newPos.offset);
                    oldPos.setLength(newPos.length);
                    modifications.add((Annotation)foldingAnnotation);
                }
            } else {
                deletions.add((FoldingAnnotation)foldingAnnotation);
            }
        }
    }

    protected void markInvalidAnnotationsForDeletion(List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing) {
        Iterator iter = this.projectionAnnotationModel.getAnnotationIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                if (!(anno instanceof FoldingAnnotation var5_5)) continue;
                Position pos = this.projectionAnnotationModel.getPosition(anno);
                if (pos.length == 0) {
                    deletions.add((FoldingAnnotation)folding);
                    continue;
                }
                existing.add((FoldingAnnotation)folding);
            }
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion partition) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.reconcile(null);
    }

    protected class FoldingAnnotation
    extends ProjectionAnnotation {
        private boolean visible;

        public FoldingAnnotation(boolean isCollapsed) {
            super(isCollapsed);
            this.visible = false;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.visible = false;
                return;
            }
            this.visible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.visible) {
                super.markCollapsed();
            }
        }
    }
}

