/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import com.google.gson.annotations.SerializedName;
import org.eclipse.lsp4j.debug.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * An ExceptionBreakpointsFilter is shown in the UI as an filter option for configuring how exceptions are dealt
 * with.
 */
@SuppressWarnings("all")
public class ExceptionBreakpointsFilter {
  /**
   * The internal ID of the filter option. This value is passed to the 'setExceptionBreakpoints' request.
   */
  @NonNull
  private String filter;
  
  /**
   * The name of the filter option. This is shown in the UI.
   */
  @NonNull
  private String label;
  
  /**
   * An optional help text providing additional information about the exception
   * filter. This string is typically shown as a hover and must be translated.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.45
   */
  private String description;
  
  /**
   * Initial value of the filter option. If not specified a value 'false' is assumed.
   * <p>
   * This is an optional property.
   */
  @SerializedName(value = "default")
  private Boolean default_;
  
  /**
   * Controls whether a condition can be specified for this filter option. If false or missing, a condition can not
   * be set.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.43
   */
  private Boolean supportsCondition;
  
  /**
   * An optional help text providing information about the condition. This
   * string is shown as the placeholder text for a text box and must be
   * translated.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.45
   */
  private String conditionDescription;
  
  /**
   * The internal ID of the filter option. This value is passed to the 'setExceptionBreakpoints' request.
   */
  @Pure
  @NonNull
  public String getFilter() {
    return this.filter;
  }
  
  /**
   * The internal ID of the filter option. This value is passed to the 'setExceptionBreakpoints' request.
   */
  public void setFilter(@NonNull final String filter) {
    this.filter = Preconditions.checkNotNull(filter, "filter");
  }
  
  /**
   * The name of the filter option. This is shown in the UI.
   */
  @Pure
  @NonNull
  public String getLabel() {
    return this.label;
  }
  
  /**
   * The name of the filter option. This is shown in the UI.
   */
  public void setLabel(@NonNull final String label) {
    this.label = Preconditions.checkNotNull(label, "label");
  }
  
  /**
   * An optional help text providing additional information about the exception
   * filter. This string is typically shown as a hover and must be translated.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.45
   */
  @Pure
  public String getDescription() {
    return this.description;
  }
  
  /**
   * An optional help text providing additional information about the exception
   * filter. This string is typically shown as a hover and must be translated.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.45
   */
  public void setDescription(final String description) {
    this.description = description;
  }
  
  /**
   * Initial value of the filter option. If not specified a value 'false' is assumed.
   * <p>
   * This is an optional property.
   */
  @Pure
  public Boolean getDefault_() {
    return this.default_;
  }
  
  /**
   * Initial value of the filter option. If not specified a value 'false' is assumed.
   * <p>
   * This is an optional property.
   */
  public void setDefault_(final Boolean default_) {
    this.default_ = default_;
  }
  
  /**
   * Controls whether a condition can be specified for this filter option. If false or missing, a condition can not
   * be set.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.43
   */
  @Pure
  public Boolean getSupportsCondition() {
    return this.supportsCondition;
  }
  
  /**
   * Controls whether a condition can be specified for this filter option. If false or missing, a condition can not
   * be set.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.43
   */
  public void setSupportsCondition(final Boolean supportsCondition) {
    this.supportsCondition = supportsCondition;
  }
  
  /**
   * An optional help text providing information about the condition. This
   * string is shown as the placeholder text for a text box and must be
   * translated.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.45
   */
  @Pure
  public String getConditionDescription() {
    return this.conditionDescription;
  }
  
  /**
   * An optional help text providing information about the condition. This
   * string is shown as the placeholder text for a text box and must be
   * translated.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.45
   */
  public void setConditionDescription(final String conditionDescription) {
    this.conditionDescription = conditionDescription;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("filter", this.filter);
    b.add("label", this.label);
    b.add("description", this.description);
    b.add("default_", this.default_);
    b.add("supportsCondition", this.supportsCondition);
    b.add("conditionDescription", this.conditionDescription);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ExceptionBreakpointsFilter other = (ExceptionBreakpointsFilter) obj;
    if (this.filter == null) {
      if (other.filter != null)
        return false;
    } else if (!this.filter.equals(other.filter))
      return false;
    if (this.label == null) {
      if (other.label != null)
        return false;
    } else if (!this.label.equals(other.label))
      return false;
    if (this.description == null) {
      if (other.description != null)
        return false;
    } else if (!this.description.equals(other.description))
      return false;
    if (this.default_ == null) {
      if (other.default_ != null)
        return false;
    } else if (!this.default_.equals(other.default_))
      return false;
    if (this.supportsCondition == null) {
      if (other.supportsCondition != null)
        return false;
    } else if (!this.supportsCondition.equals(other.supportsCondition))
      return false;
    if (this.conditionDescription == null) {
      if (other.conditionDescription != null)
        return false;
    } else if (!this.conditionDescription.equals(other.conditionDescription))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.filter== null) ? 0 : this.filter.hashCode());
    result = prime * result + ((this.label== null) ? 0 : this.label.hashCode());
    result = prime * result + ((this.description== null) ? 0 : this.description.hashCode());
    result = prime * result + ((this.default_== null) ? 0 : this.default_.hashCode());
    result = prime * result + ((this.supportsCondition== null) ? 0 : this.supportsCondition.hashCode());
    return prime * result + ((this.conditionDescription== null) ? 0 : this.conditionDescription.hashCode());
  }
}
