/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tm4e.registry.IGrammarDefinition;

public class GrammarCache {
    private final Map<String, IGrammarDefinition> definitions = new HashMap<String, IGrammarDefinition>();
    private final Map<String, Collection<String>> injections = new HashMap<String, Collection<String>>();
    private final Map<IContentType, String> scopeNameBindings = new HashMap<IContentType, String>();

    public void registerGrammarDefinition(IGrammarDefinition definition) {
        this.definitions.put(definition.getScopeName(), definition);
    }

    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        this.definitions.remove(definition.getScopeName());
    }

    public Collection<IGrammarDefinition> getDefinitions() {
        return this.definitions.values();
    }

    public IGrammarDefinition getDefinition(String scopeName) {
        return this.definitions.get(scopeName);
    }

    public Collection<String> getInjections(String scopeName) {
        return this.injections.get(scopeName);
    }

    public void registerInjection(String scopeName, String injectTo) {
        Collection<String> injections = this.getInjections(injectTo);
        if (injections == null) {
            injections = new ArrayList<String>();
            this.injections.put(injectTo, injections);
        }
        injections.add(scopeName);
    }

    public String getScopeNameForContentType(IContentType contentType) {
        return this.scopeNameBindings.get(contentType);
    }

    public List<IContentType> getContentTypesForScope(String scopeName) {
        if (scopeName == null) {
            return List.of();
        }
        return this.scopeNameBindings.entrySet().stream().filter(map -> scopeName.equals(map.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void registerContentTypeBinding(IContentType contentType, String scopeName) {
        this.scopeNameBindings.put(contentType, scopeName);
    }
}

