/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.navigator;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;

public class CompressedJavaProjectCVSDecorator
extends CVSLightweightDecorator {
    private static final SynchronizationStateTester DEFAULT_TESTER = new SynchronizationStateTester();

    public void decorate(Object element, IDecoration decoration) {
        block5: {
            if (element instanceof CompressedJavaProject) {
                SynchronizationStateTester tester = this.getTester(decoration);
                try {
                    if (tester.isDecorationEnabled(element)) {
                        CVSDecoration cvsDecoration = CompressedJavaProjectCVSDecorator.getDecoration(this.getElementFatherProject(element), tester);
                        cvsDecoration.apply(decoration);
                    }
                }
                catch (CoreException e) {
                    ServletUIPlugin.log((Exception)((Object)e));
                }
                catch (IllegalStateException e) {
                    ServletUIPlugin.log(e);
                    if (Platform.getBundle((String)"org.eclipse.team.cvs.ui").getState() != 32 || Platform.getBundle((String)"org.eclipse.jst.servlet.ui").getState() != 32) break block5;
                    throw e;
                }
            }
        }
    }

    protected IProject getElementFatherProject(Object element) {
        CompressedJavaProject cjp = (CompressedJavaProject)element;
        IProject fatherIproject = cjp.getProject();
        return fatherIproject;
    }

    protected SynchronizationStateTester getTester(IDecoration decoration) {
        IDecorationContext context = decoration.getDecorationContext();
        SynchronizationStateTester tester = DEFAULT_TESTER;
        Object property = context.getProperty("org.eclipse.team.ui.syncStateTester");
        if (property instanceof SynchronizationStateTester) {
            tester = (SynchronizationStateTester)property;
        }
        return tester;
    }

    public static CVSDecoration getDecoration(Object element, SynchronizationStateTester tester) throws CoreException {
        CVSDecoration decoration = new CVSDecoration();
        int state = 0;
        if (CompressedJavaProjectCVSDecorator.isSupervised(element)) {
            decoration.setHasRemote(true);
            state = CompressedJavaProjectCVSDecorator.getElementCVSState(element, tester);
            decoration.setStateFlags(state);
        } else {
            decoration.setIgnored(true);
        }
        return decoration;
    }

    private static int getElementCVSState(Object element, SynchronizationStateTester tester) throws CoreException {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        int state = tester.getState(element, store.getBoolean("pref_calculate_dirty") ? 263 : 0, (IProgressMonitor)new NullProgressMonitor());
        return state;
    }

    protected static IResource[] getTraversalRoots(Object element) throws CoreException {
        HashSet<IResource> result = new HashSet<IResource>();
        ResourceMapping mapping = Utils.getResourceMapping((Object)element);
        if (mapping != null) {
            ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                IResource[] resources = traversal.getResources();
                int j = 0;
                while (j < resources.length) {
                    IResource resource = resources[j];
                    result.add(resource);
                    ++j;
                }
                ++i;
            }
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected static boolean isSupervised(Object element) throws CoreException {
        IResource[] resources = CompressedJavaProjectCVSDecorator.getTraversalRoots(element);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (CompressedJavaProjectCVSDecorator.getSubscriber().isSupervised(resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static CVSWorkspaceSubscriber getSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }
}

