/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.ear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public abstract class AbstractEarNode {
    public static int MODULES_TYPE = 0;
    public static int LIBS_TYPE = 1;
    protected int type;
    protected static List implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb", "jst.connector");
    private IProject earProject;

    public AbstractEarNode(IProject earProject) {
        this.earProject = earProject;
    }

    public IProject getEarProject() {
        return this.earProject;
    }

    public abstract List getModules();

    public int getType() {
        return this.type;
    }

    public abstract String getText();

    protected List getComponentReferencesAsList(List componentTypes, IVirtualComponent virtualComponent, IPath runtimePath) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = virtualComponent;
        if (earComponent != null) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)module))) {
                        if (runtimePath != null) {
                            IPath runtimePath2 = this.getRealRuntimePath(refComponents[i]);
                            if (runtimePath2.equals((Object)runtimePath)) {
                                components.add(refComponents[i]);
                            }
                        } else {
                            components.add(refComponents[i]);
                        }
                    }
                }
                ++i;
            }
        }
        return components;
    }

    protected List getBinariesInLibDir(IVirtualComponent virtualComponent, IPath runtimePath, List componentTypes) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = virtualComponent;
        if (earComponent != null) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null && module.isBinary() && this.getRealRuntimePath(refComponents[i]).equals((Object)runtimePath)) {
                    if (componentTypes != null && !componentTypes.contains(JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)module))) {
                        if (!runtimePath.equals((Object)new Path("/"))) {
                            components.add(refComponents[i]);
                        }
                    } else {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    protected List getBinariesInLibDir(IVirtualComponent virtualComponent, IPath runtimePath) {
        return this.getBinariesInLibDir(virtualComponent, runtimePath, null);
    }

    protected IPath getRealRuntimePath(IVirtualReference vr) {
        Path namePath;
        IPath runtimePath2 = vr.getRuntimePath();
        if (vr.getArchiveName() != null && (namePath = new Path(vr.getArchiveName())).segmentCount() > 1 && runtimePath2.segmentCount() == 0) {
            runtimePath2 = new Path("/" + namePath.removeLastSegments(1).toPortableString());
        }
        return runtimePath2;
    }
}

