/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentmodel.annotation.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileInfo;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileRegistry;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class CMAnnotationFileRegistryReader {
    private static final String EXTENSION_POINT_ID = "annotationFiles";
    private static final String TAG_NAME = "annotationFile";
    private static final String ATT_URI = "uri";
    private static final String ATT_LOCATION = "location";
    private static final String ATT_LOCATOR = "locator";
    private static final String ATT_PARSER = "parser";
    private CMAnnotationFileRegistry annotationFileRegistry;

    public CMAnnotationFileRegistryReader(CMAnnotationFileRegistry annotationFileRegistry) {
        this.annotationFileRegistry = annotationFileRegistry;
    }

    public void readRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.jst.jsf.common", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_NAME)) {
            String uri = element.getAttribute(ATT_URI);
            String location = element.getAttribute(ATT_LOCATION);
            String locator = element.getAttribute(ATT_LOCATOR);
            String parser = element.getAttribute(ATT_PARSER);
            String bundleId = null;
            if (uri != null && location != null) {
                try {
                    bundleId = element.getContributor().getName();
                    CMAnnotationFileInfo fileInfo = new CMAnnotationFileInfo(location, bundleId, parser, locator);
                    this.annotationFileRegistry.addAnnotationFileInfo(uri, fileInfo);
                }
                catch (Exception e) {
                    JSFCommonPlugin.log(e, NLS.bind((String)Messages.CMAnnotationFileRegistryReader_problem, (Object[])new String[]{bundleId, uri, location}));
                }
            }
        }
    }
}

