/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.TableCombo;
import org.eclipse.jpt.ui.internal.mappings.details.InverseJoinColumnInJoinTableDialog;
import org.eclipse.jpt.ui.internal.mappings.details.InverseJoinColumnInJoinTableStateObject;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoinTableDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoinTableStateObject;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnsComposite;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableComposite
extends AbstractFormPane<JoinTable> {
    private WritablePropertyValueModel<Boolean> inverseJoinColumnsPaneEnablerHolder;
    private WritablePropertyValueModel<Boolean> joinColumnsPaneEnablerHolder;
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private Button overrideDefaultJoinColumnsCheckBox;

    public JoinTableComposite(AbstractFormPane<?> parentPane, PropertyValueModel<? extends JoinTable> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    public JoinTableComposite(PropertyValueModel<? extends JoinTable> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private void addInverseJoinColumn(JoinTable joinTable) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.shell(), joinTable, null);
        dialog.openDialog(this.buildAddInverseJoinColumnPostExecution());
    }

    private void addInverseJoinColumnFromDialog(InverseJoinColumnInJoinTableStateObject stateObject) {
        JoinTable subject = (JoinTable)this.subject();
        int index = subject.specifiedInverseJoinColumnsSize();
        JoinColumn joinColumn = subject.addSpecifiedInverseJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private void addJoinColumn(JoinTable joinTable) {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.shell(), joinTable, null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    private void addJoinColumnFromDialog(JoinColumnInJoinTableStateObject stateObject) {
        JoinTable subject = (JoinTable)this.subject();
        int index = subject.specifiedJoinColumnsSize();
        JoinColumn joinColumn = ((JoinTable)this.subject()).addSpecifiedJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private PostExecution<InverseJoinColumnInJoinTableDialog> buildAddInverseJoinColumnPostExecution() {
        return new PostExecution<InverseJoinColumnInJoinTableDialog>(){

            @Override
            public void execute(InverseJoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.addInverseJoinColumnFromDialog((InverseJoinColumnInJoinTableStateObject)((Object)dialog.subject()));
                }
            }
        };
    }

    private PostExecution<JoinColumnInJoinTableDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInJoinTableDialog>(){

            @Override
            public void execute(JoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.addJoinColumnFromDialog((JoinColumnInJoinTableStateObject)((Object)dialog.subject()));
                }
            }
        };
    }

    private PostExecution<InverseJoinColumnInJoinTableDialog> buildEditInverseJoinColumnPostExecution() {
        return new PostExecution<InverseJoinColumnInJoinTableDialog>(){

            @Override
            public void execute(InverseJoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.editInverseJoinColumn((InverseJoinColumnInJoinTableStateObject)((Object)dialog.subject()));
                }
            }
        };
    }

    private PostExecution<JoinColumnInJoinTableDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInJoinTableDialog>(){

            @Override
            public void execute(JoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.editJoinColumn((JoinColumnInJoinTableStateObject)((Object)dialog.subject()));
                }
            }
        };
    }

    private InverseJoinColumnsProvider buildInverseJoinColumnsEditor() {
        return new InverseJoinColumnsProvider();
    }

    private JoinColumnsProvider buildJoinColumnsEditor() {
        return new JoinColumnsProvider();
    }

    private SimplePropertyValueModel<Boolean> buildJoinColumnsPaneEnablerHolder() {
        return new SimplePropertyValueModel((Object)Boolean.FALSE);
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultHolder() {
        return new SimplePropertyValueModel();
    }

    private SelectionListener buildOverrideDefaultInverseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.updateInverseJoinColumns();
            }
        };
    }

    private SelectionListener buildOverrideDefaultSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.updateJoinColumns();
            }
        };
    }

    private Composite buildPane(Composite container, int groupBoxMargin) {
        return this.buildSubPane(container, 0, groupBoxMargin, 10, groupBoxMargin);
    }

    private TableCombo<JoinTable> buildTableCombo(Composite container) {
        return new TableCombo<JoinTable>((AbstractPane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultNameProperty");
                propertyNames.add("specifiedNameProperty");
                propertyNames.add("defaultSchemaProperty");
                propertyNames.add("specifiedSchemaProperty");
                propertyNames.add("defaultCatalogProperty");
                propertyNames.add("specifiedCatalogProperty");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultSchemaProperty" || propertyName == "specifiedSchemaProperty" || propertyName == "defaultCatalogProperty" || propertyName == "specifiedCatalogProperty") {
                    this.repopulate();
                }
            }

            @Override
            protected String defaultValue() {
                return ((JoinTable)this.subject()).getDefaultName();
            }

            @Override
            protected String schemaName() {
                return ((JoinTable)this.subject()).getSchema();
            }

            @Override
            protected void setValue(String value) {
                ((JoinTable)this.subject()).setSpecifiedName(value);
            }

            @Override
            protected Table table() {
                return ((JoinTable)this.subject()).getDbTable();
            }

            @Override
            protected String value() {
                return ((JoinTable)this.subject()).getSpecifiedName();
            }
        };
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updateJoinColumnPanesEnablement(true);
    }

    private void editInverseJoinColumn(InverseJoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void editInverseJoinColumn(JoinColumn joinColumn) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.shell(), (JoinTable)this.subject(), joinColumn);
        dialog.openDialog(this.buildEditInverseJoinColumnPostExecution());
    }

    private void editJoinColumn(JoinColumn joinColumn) {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.shell(), (JoinTable)this.subject(), joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    private void editJoinColumn(JoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.updateJoinColumnPanesEnablement(enabled);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinColumnsPaneEnablerHolder = this.buildJoinColumnsPaneEnablerHolder();
        this.inverseJoinColumnsPaneEnablerHolder = this.buildJoinColumnsPaneEnablerHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.groupBoxMargin();
        TableCombo<JoinTable> tableCombo = this.buildTableCombo(container);
        this.buildLabeledComposite(this.buildPane(container, groupBoxMargin), JptUiMappingsMessages.JoinTableComposite_name, (Control)tableCombo.getControl(), "org.eclipse.jpt.ui.mapping_joinTableName");
        Group joinColumnGroupPane = this.buildTitledPane(container, JptUiMappingsMessages.JoinTableComposite_joinColumn);
        this.overrideDefaultJoinColumnsCheckBox = this.buildCheckBox(this.buildSubPane((Composite)joinColumnGroupPane, 8), JptUiMappingsMessages.JoinTableComposite_overrideDefaultJoinColumns, this.buildOverrideDefaultHolder());
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(this.buildOverrideDefaultSelectionListener());
        JoinColumnsComposite<JoinTable> joinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)joinColumnGroupPane, this.buildJoinColumnsEditor());
        this.installJoinColumnsPaneEnabler(joinColumnsComposite);
        this.removeFromEnablementControl((Control)joinColumnsComposite.getControl());
        Group inverseJoinColumnGroupPane = this.buildTitledPane(container, JptUiMappingsMessages.JoinTableComposite_inverseJoinColumn);
        this.overrideDefaultInverseJoinColumnsCheckBox = this.buildCheckBox(this.buildSubPane((Composite)inverseJoinColumnGroupPane, 8), JptUiMappingsMessages.JoinTableComposite_overrideDefaultInverseJoinColumns, this.buildOverrideDefaultHolder());
        this.overrideDefaultInverseJoinColumnsCheckBox.addSelectionListener(this.buildOverrideDefaultInverseSelectionListener());
        JoinColumnsComposite<JoinTable> inverseJoinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)inverseJoinColumnGroupPane, this.buildInverseJoinColumnsEditor());
        this.installInverseJoinColumnsPaneEnabler(inverseJoinColumnsComposite);
        this.removeFromEnablementControl((Control)inverseJoinColumnsComposite.getControl());
    }

    private void installInverseJoinColumnsPaneEnabler(JoinColumnsComposite<JoinTable> pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.inverseJoinColumnsPaneEnablerHolder, (AbstractPane<?>)pane);
    }

    private void installJoinColumnsPaneEnabler(JoinColumnsComposite<JoinTable> pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.joinColumnsPaneEnablerHolder, (AbstractPane<?>)pane);
    }

    private void updateInverseJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        JoinTable joinTable = (JoinTable)this.subject();
        boolean selected = this.overrideDefaultInverseJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                JoinColumn defaultJoinColumn = joinTable.getDefaultInverseJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    JoinColumn joinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                }
            } else {
                int index = joinTable.specifiedInverseJoinColumnsSize();
                while (--index >= 0) {
                    joinTable.removeSpecifiedInverseJoinColumn(index);
                }
            }
            this.inverseJoinColumnsPaneEnablerHolder.setValue((Object)selected);
        }
        finally {
            this.setPopulating(false);
        }
    }

    private void updateJoinColumnPanesEnablement(boolean globalEnablement) {
        JoinTable subject = (JoinTable)this.subject();
        boolean enabled = globalEnablement && subject != null && subject.containsSpecifiedJoinColumns();
        boolean inverseEnabled = globalEnablement && subject != null && subject.containsSpecifiedInverseJoinColumns();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(enabled);
        this.overrideDefaultInverseJoinColumnsCheckBox.setSelection(inverseEnabled);
        this.joinColumnsPaneEnablerHolder.setValue((Object)enabled);
        this.inverseJoinColumnsPaneEnablerHolder.setValue((Object)inverseEnabled);
    }

    private void updateJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        JoinTable joinTable = (JoinTable)this.subject();
        boolean selected = this.overrideDefaultJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                JoinColumn defaultJoinColumn = joinTable.getDefaultJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    JoinColumn joinColumn = joinTable.addSpecifiedJoinColumn(0);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                }
            } else {
                int index = joinTable.specifiedJoinColumnsSize();
                while (--index >= 0) {
                    joinTable.removeSpecifiedJoinColumn(index);
                }
            }
            this.joinColumnsPaneEnablerHolder.setValue((Object)selected);
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseJoinColumnsProvider
    implements JoinColumnsComposite.IJoinColumnsEditor<JoinTable> {
        private InverseJoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(JoinTable subject) {
            JoinTableComposite.this.addInverseJoinColumn(subject);
        }

        @Override
        public JoinColumn defaultJoinColumn(JoinTable subject) {
            return subject.getDefaultInverseJoinColumn();
        }

        @Override
        public String defaultPropertyName() {
            return "defaultInverseJoinColumn";
        }

        @Override
        public void editJoinColumn(JoinTable subject, JoinColumn joinColumn) {
            JoinTableComposite.this.editInverseJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(JoinTable subject) {
            return subject.containsSpecifiedInverseJoinColumns();
        }

        @Override
        public void removeJoinColumns(JoinTable subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedInverseJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(JoinTable subject) {
            return subject.specifiedInverseJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(JoinTable subject) {
            return subject.specifiedInverseJoinColumnsSize();
        }

        @Override
        public String specifiedListPropertyName() {
            return "specifiedInverseJoinColumnsList";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsProvider
    implements JoinColumnsComposite.IJoinColumnsEditor<JoinTable> {
        private JoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(JoinTable subject) {
            JoinTableComposite.this.addJoinColumn(subject);
        }

        @Override
        public JoinColumn defaultJoinColumn(JoinTable subject) {
            return subject.getDefaultJoinColumn();
        }

        @Override
        public String defaultPropertyName() {
            return "defaultJoinColumn";
        }

        @Override
        public void editJoinColumn(JoinTable subject, JoinColumn joinColumn) {
            JoinTableComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(JoinTable subject) {
            return subject.containsSpecifiedJoinColumns();
        }

        @Override
        public void removeJoinColumns(JoinTable subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(JoinTable subject) {
            return subject.specifiedJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(JoinTable subject) {
            return subject.specifiedJoinColumnsSize();
        }

        @Override
        public String specifiedListPropertyName() {
            return "specifiedJoinColumnsList";
        }
    }
}

