/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.Java50Fix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class Java50CleanUp
extends AbstractCleanUp {
    public Java50CleanUp(Map options) {
        super(options);
    }

    public Java50CleanUp() {
    }

    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        boolean addAnotations = this.isEnabled("cleanup.add_missing_annotations");
        return addAnotations && this.isEnabled("cleanup.add_missing_override_annotations") || addAnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations") || this.isEnabled("cleanup.use_arguments_for_raw_type_references");
    }

    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean addAnotations = this.isEnabled("cleanup.add_missing_annotations");
        return Java50Fix.createCleanUp(compilationUnit, addAnotations && this.isEnabled("cleanup.add_missing_override_annotations"), addAnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return Java50Fix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations"), this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingOverrideAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingDeprecatedAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "warning");
        }
        return options;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingOverride_description);
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingDeprecated_description);
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            result.add(MultiFixMessages.Java50CleanUp_AddTypeParameters_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E {\n");
        buf.append("    /**\n");
        buf.append("     * @deprecated\n");
        buf.append("     */\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            buf.append("    @Deprecated\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        buf.append("class ESub extends E {\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            buf.append("    @Override\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        Java50Fix fix;
        return this.isEnabled("cleanup.use_arguments_for_raw_type_references") && (fix = Java50Fix.createRawTypeReferenceFix(compilationUnit, problem)) != null;
    }

    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        int id;
        int i;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result += this.getNumberOfProblems(problems, 67109491);
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 536871540 || id == 536871541 || id == 536871542) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 16777748 || id == 16777788 || id == 16777747) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }
}

