/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.weighted;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.weighted.SimpleTree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeSet;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class WeightedTreeSetTest {
    private static final String OBJ1 = "obj1";
    private static final String OBJ2 = "obj2";

    @Test
    public void testAddingSimpleData() {
        int initialWeight = 10;
        String element1 = "element1";
        String element2 = "element2";
        WeightedTreeSet treeSet = new WeightedTreeSet();
        Collection elements = treeSet.getElements();
        Assert.assertTrue((boolean)elements.isEmpty());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element1).isEmpty());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element2).isEmpty());
        WeightedTree wt = new WeightedTree((Object)OBJ1, (long)initialWeight);
        treeSet.addWeightedTree((Object)element1, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)element1, elements.iterator().next());
        Collection trees = treeSet.getTreesFor((Object)element1);
        Assert.assertEquals((long)1L, (long)trees.size());
        Assert.assertEquals((Object)wt, trees.iterator().next());
        wt = new WeightedTree((Object)OBJ1, (long)initialWeight);
        treeSet.addWeightedTree((Object)element1, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)element1, elements.iterator().next());
        trees = treeSet.getTreesFor((Object)element1);
        Assert.assertEquals((long)1L, (long)trees.size());
        WeightedTree tree = (WeightedTree)trees.iterator().next();
        Assert.assertEquals((Object)wt.getObject(), (Object)tree.getObject());
        Assert.assertEquals((long)(initialWeight * 2), (long)tree.getWeight());
        wt = new WeightedTree((Object)OBJ2, (long)initialWeight);
        treeSet.addWeightedTree((Object)element1, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)element1, elements.iterator().next());
        Collection el1Trees = treeSet.getTreesFor((Object)element1);
        Assert.assertEquals((long)2L, (long)el1Trees.size());
        wt = new WeightedTree((Object)OBJ1, (long)initialWeight);
        treeSet.addWeightedTree((Object)element2, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)2L, (long)elements.size());
        trees = treeSet.getTreesFor((Object)element1);
        Assert.assertEquals((Object)el1Trees, (Object)trees);
        trees = treeSet.getTreesFor((Object)element2);
        Assert.assertEquals((long)1L, (long)trees.size());
    }

    @Test
    public void testAddingTreeData() {
        int initialWeight = 10;
        SimpleTree element1 = new SimpleTree("element1");
        SimpleTree element2 = new SimpleTree("element2");
        SimpleTree element3 = new SimpleTree("element3");
        element1.addChild(element2);
        element1.addChild(element3);
        SimpleTree element4 = new SimpleTree("element3");
        WeightedTreeSet treeSet = new WeightedTreeSet();
        Collection elements = treeSet.getElements();
        Assert.assertTrue((boolean)elements.isEmpty());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element1).isEmpty());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element2).isEmpty());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element3).isEmpty());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element4).isEmpty());
        WeightedTree wt = new WeightedTree((Object)OBJ1, (long)initialWeight);
        treeSet.addWeightedTree((Object)element2, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)element1, elements.iterator().next());
        Collection trees = treeSet.getTreesFor((Object)element2);
        Assert.assertEquals((long)1L, (long)trees.size());
        Assert.assertEquals((Object)wt, trees.iterator().next());
        Assert.assertTrue((boolean)treeSet.getTreesFor((Object)element1).isEmpty());
        wt = new WeightedTree((Object)OBJ1, (long)initialWeight);
        treeSet.addWeightedTree((Object)element3, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)element1, elements.iterator().next());
        trees = treeSet.getTreesFor((Object)element3);
        Assert.assertEquals((long)1L, (long)trees.size());
        wt = new WeightedTree((Object)OBJ1, (long)initialWeight);
        treeSet.addWeightedTree((Object)element3, wt);
        elements = treeSet.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)element1, elements.iterator().next());
        trees = treeSet.getTreesFor((Object)element3);
        Assert.assertEquals((long)1L, (long)trees.size());
        WeightedTree tree = (WeightedTree)trees.iterator().next();
        Assert.assertEquals((Object)wt.getObject(), (Object)tree.getObject());
        Assert.assertEquals((long)(initialWeight * 2), (long)tree.getWeight());
    }
}

