/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.utility.UnacceptableOperationNotificator;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAction
extends AbstractSynchronizeModelAction {
    protected boolean advancedMode;

    public UpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.advancedMode = false;
    }

    public UpdateAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.advancedMode = true;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12}){

            public boolean select(SyncInfo info) {
                return super.select(info) && !IStateFilter.SF_OBSTRUCTED.accept(((UpdateSyncInfo)info).getLocalResource());
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(configuration.getSite().getShell(), this.syncInfoSelector.getSelectedResources());
        if (resources == null || resources.length == 0) {
            return null;
        }
        IResource[] missing = FileUtility.getResourcesRecursive((IResource[])(resources = FileUtility.addOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_UNVERSIONED)), (IStateFilter)org.eclipse.team.svn.ui.action.local.UpdateAction.SF_MISSING_RESOURCES);
        if (missing.length > 0 && !org.eclipse.team.svn.ui.action.local.UpdateAction.updateMissing(configuration.getSite().getShell(), missing)) {
            return null;
        }
        if (this.advancedMode) {
            String message = resources.length == 1 ? SVNUIMessages.UpdateAll_Message_Single : SVNUIMessages.format((String)SVNUIMessages.UpdateAll_Message_Multi, (Object[])new String[]{String.valueOf(resources.length)});
            MessageDialog dlg = new MessageDialog(configuration.getSite().getShell(), SVNUIMessages.UpdateAll_Title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dlg.open() != 0) {
                return null;
            }
        }
        CompositeOperation op = new CompositeOperation("Operation_Update", SVNMessages.class);
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        Map<SVNRevision, Set<IResource>> splitted = UpdateAction.splitByPegRevision(this, resources);
        for (Map.Entry<SVNRevision, Set<IResource>> entry : splitted.entrySet()) {
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            UpdateOperation mainOp = new UpdateOperation(entry.getValue().toArray(new IResource[0]), entry.getKey(), ignoreExternals);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp), new IActionOperation[]{mainOp});
            op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        }
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources));
        return op;
    }

    public static Map<SVNRevision, Set<IResource>> splitByPegRevision(AbstractSynchronizeModelAction action, IResource[] resources) {
        HashMap<SVNRevision, Set<IResource>> splitted = new HashMap<SVNRevision, Set<IResource>>();
        splitted.put(SVNRevision.HEAD, new HashSet<IResource>(Arrays.asList(resources)));
        return splitted;
    }
}

