/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.birt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifTreeLabelProvider;
import org.eclipse.linuxtools.internal.valgrind.massif.birt.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ChartLocationsDialog
extends ListDialog {
    protected List<MassifHeapTreeNode> allocs;

    public ChartLocationsDialog(Shell parent) {
        super(parent);
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider((ILabelProvider)new MassifTreeLabelProvider());
        this.setMessage(Messages.getString("ChartLocationsDialog.Message"));
        this.setTitle(Messages.getString("ChartLocationsDialog.Title"));
    }

    public void setInput(Object input) {
        this.setInput((MassifSnapshot)input);
    }

    public void setInput(MassifSnapshot snapshot) {
        MassifHeapTreeNode node = snapshot.getRoot();
        this.allocs = new ArrayList<MassifHeapTreeNode>(node.getChildren().length);
        MassifHeapTreeNode[] massifHeapTreeNodeArray = node.getChildren();
        int n = massifHeapTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MassifHeapTreeNode alloc = massifHeapTreeNodeArray[n2];
            if (alloc.hasSourceFile()) {
                this.allocs.add(alloc);
            }
            ++n2;
        }
        super.setInput(this.allocs);
    }

    public int open() {
        int result = 0;
        if (this.allocs.size() > 1) {
            result = super.open();
        }
        return result;
    }

    public void openEditorForResult() {
        MassifHeapTreeNode element = null;
        if (this.allocs.size() > 1) {
            element = (MassifHeapTreeNode)this.getResult()[0];
        } else if (this.allocs.size() == 1) {
            element = this.allocs.get(0);
        }
        if (element != null) {
            MassifPlugin.getDefault().openEditorForNode(element);
        }
    }
}

