/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.rpm.core.RPMProjectCreator;
import org.eclipse.linuxtools.rpm.core.utils.FileDownloadJob;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.ui.SRPMImportOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class SRPMImportPage
extends WizardPage {
    private Text sourceSRPM;
    private Text locationPath;

    public SRPMImportPage(IWorkbench aWorkbench) {
        super(Messages.getString("SRPMImportPage.Import_SRPM"), Messages.getString("SRPMImportPage.Select_project_to_import"), null);
        this.setPageComplete(false);
        this.setDescription(Messages.getString("SRPMImportPage.Select_project_to_import"));
    }

    private File getSelectedSRPM() {
        String srpmName = this.sourceSRPM.getText();
        if (srpmName == null || srpmName.equals("")) {
            return null;
        }
        if (srpmName.startsWith("http://")) {
            try {
                URL url = new URL(srpmName);
                URLConnection content = url.openConnection();
                File tempFile = new File(System.getProperty("java.io.tmpdir"), srpmName.substring(srpmName.lastIndexOf(47) + 1));
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                final FileDownloadJob downloadJob = new FileDownloadJob(tempFile, content);
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        downloadJob.run(monitor);
                    }
                });
                return tempFile;
            }
            catch (Exception exception) {}
        }
        return new File(this.sourceSRPM.getText());
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        this.createSourceRPMCombo(composite);
        this.createProjectDetails(composite);
    }

    private void createProjectDetails(Composite parent) {
        String[] types;
        final Button defaultSettings = new Button(parent, 32);
        defaultSettings.setText(Messages.getString("SRPMImportPage.0"));
        defaultSettings.setSelection(true);
        final Group specGrid = new Group(parent, 0);
        defaultSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (defaultSettings.getSelection()) {
                    Control[] controlArray = specGrid.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        specGrid.setEnabled(false);
                        control.setEnabled(false);
                        ++n2;
                    }
                } else {
                    Control[] controlArray = specGrid.getChildren();
                    int n = controlArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Control control = controlArray[n3];
                        specGrid.setEnabled(true);
                        control.setEnabled(true);
                        ++n3;
                    }
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        specGrid.setLayout((Layout)layout);
        specGrid.setText(Messages.getString("SRPMImportPage.1"));
        specGrid.setLayoutData((Object)new GridData(768));
        specGrid.setEnabled(false);
        Label locationLabel = new Label((Composite)specGrid, 0);
        locationLabel.setText(Messages.getString("SRPMImportPage.2"));
        locationLabel.setEnabled(false);
        this.locationPath = new Text((Composite)specGrid, 2052);
        this.locationPath.setEnabled(false);
        this.locationPath.setLayoutData((Object)new GridData(768));
        Button containerBrowseButton = new Button((Composite)specGrid, 8);
        containerBrowseButton.setText(Messages.getString("SRPMImportPage.3"));
        containerBrowseButton.setLayoutData((Object)new GridData(256));
        containerBrowseButton.setEnabled(false);
        Label typeLabel = new Label((Composite)specGrid, 0);
        typeLabel.setText(Messages.getString("SRPMImportPage.4"));
        typeLabel.setEnabled(false);
        Combo combo = new Combo((Composite)specGrid, 0);
        String[] stringArray = types = new String[]{Messages.getString("SRPMImportPage.5"), Messages.getString("SRPMImportPage.6")};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            combo.add(type);
            ++n2;
        }
        combo.select(0);
        combo.setLayoutData((Object)new GridData(2));
        combo.setEnabled(false);
    }

    private void createSourceRPMCombo(Composite parent) {
        Group specGrid = new Group(parent, 0);
        specGrid.setLayout((Layout)new GridLayout());
        specGrid.setText(Messages.getString("SRPMImportPage.SRPM_Name"));
        specGrid.setLayoutData((Object)new GridData(768));
        Composite sourceSpecComposite = new Composite((Composite)specGrid, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        sourceSpecComposite.setLayout((Layout)layout);
        sourceSpecComposite.setLayoutData((Object)new GridData(768));
        this.sourceSRPM = new Text(sourceSpecComposite, 2048);
        this.sourceSRPM.setToolTipText(Messages.getString("SRPMImportPage.toolTip_SRPM_Name"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sourceSRPM.setLayoutData((Object)gridData);
        this.sourceSRPM.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean validSRPM = SRPMImportPage.this.canFinish();
                if (validSRPM) {
                    SRPMImportPage.this.setPageComplete(validSRPM);
                    SRPMImportPage.this.changeProjectSettings();
                }
            }
        });
        Button srpmBrowse = new Button(sourceSpecComposite, 8);
        srpmBrowse.setToolTipText(Messages.getString("SRPMImportPage.toolTip_Open_file_navigator"));
        srpmBrowse.setText(Messages.getString("RPMPage.Browse"));
        srpmBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                File testSRPMfilename;
                FileDialog srpmBrowseDialog = new FileDialog(SRPMImportPage.this.getContainer().getShell(), 4096);
                String selectedSRPM_name = srpmBrowseDialog.open();
                if (selectedSRPM_name != null && (testSRPMfilename = new File(selectedSRPM_name)).isFile()) {
                    SRPMImportPage.this.sourceSRPM.setText(selectedSRPM_name);
                }
            }
        });
    }

    private void changeProjectSettings() {
        String srpmName = this.sourceSRPM.getText();
        this.locationPath.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.getProjectName(srpmName)).toFile().getAbsolutePath());
    }

    private String getProjectName(String srpmName) {
        String projectName = srpmName.substring(srpmName.lastIndexOf(47) + 1);
        return projectName.replaceAll("-[\\d|\\.]+-[\\d|\\.].+", "");
    }

    public boolean canFinish() {
        block8: {
            String sourceSRPMName = this.sourceSRPM.getText();
            if (!sourceSRPMName.isEmpty() && this.sourceSRPM.getText().lastIndexOf(".src.rpm") == -1) {
                this.setErrorMessage(Messages.getString("SRPMImportPage.No_src_rpm_ext"));
                return false;
            }
            if (sourceSRPMName.startsWith("http://")) {
                try {
                    URL url = new URL(sourceSRPMName);
                    if (404 == ((HttpURLConnection)url.openConnection()).getResponseCode()) {
                        this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                        return false;
                    }
                    break block8;
                }
                catch (MalformedURLException malformedURLException) {
                    this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                    return false;
                }
                catch (IOException iOException) {
                    this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                    return false;
                }
            }
            if (sourceSRPMName.equals("")) {
                return false;
            }
            File srpm = new File(sourceSRPMName);
            if (!srpm.isFile()) {
                this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean finish() {
        IProject detailedProject = this.getNewProject();
        SRPMImportOperation srpmImportOp = null;
        try {
            srpmImportOp = new SRPMImportOperation(detailedProject, this.getSelectedSRPM());
            this.getContainer().run(true, true, (IRunnableWithProgress)srpmImportOp);
        }
        catch (Exception e) {
            this.setErrorMessage(e.toString());
            return false;
        }
        MultiStatus srpmImportStatus = srpmImportOp.getStatus();
        if (!srpmImportStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.getString("SRPMImportPage.Errors_importing_SRPM"), null, (IStatus)srpmImportStatus);
            return false;
        }
        return true;
    }

    private IProject getNewProject() {
        IPath path = Path.fromOSString((String)this.locationPath.getText());
        RPMProjectCreator projectCreator = new RPMProjectCreator();
        projectCreator.create(this.getProjectName(path.lastSegment()), path.removeLastSegments(1), (IProgressMonitor)new NullProgressMonitor());
        return projectCreator.getLatestProject();
    }
}

