/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class ValidateProjectLocationOperation {
    private static final File WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
    private final Set<EclipseProject> projects;

    public ValidateProjectLocationOperation(Set<? extends EclipseProject> projects) {
        this.projects = ImmutableSet.copyOf(projects);
    }

    public void run(IProgressMonitor monitor) {
        ArrayListMultimap locationToProjectNames = ArrayListMultimap.create();
        for (EclipseProject project : this.projects) {
            locationToProjectNames.put((Object)project.getProjectDirectory(), (Object)project.getName());
        }
        for (File location : locationToProjectNames.keySet()) {
            List projectNames = locationToProjectNames.get((Object)location);
            if (projectNames.size() > 1) {
                throw new UnsupportedConfigurationException(String.format("Multiple projects in the build are located in the same directory: %s", location.getAbsolutePath()));
            }
            if (!location.equals(WORKSPACE_ROOT)) continue;
            throw new UnsupportedConfigurationException(String.format("Project %s location matches workspace root %s", projectNames.get(0), WORKSPACE_ROOT.getAbsolutePath()));
        }
    }
}

