/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;

public final class ZIPUtil {
    @Deprecated
    public static final int DEFALULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int ORDER_KEEP = -1;
    private static final int ORDER_SWAP = 1;

    private ZIPUtil() {
    }

    /*
     * Unable to fully structure code
     */
    public static void zip(ZipEntryHandler handler, File zipFile) throws IORuntimeException {
        block10: {
            buffer = new byte[4096];
            context = new EntryContext();
            fos = IOUtil.openOutputStream(zipFile);
            zos = null;
            input = null;
            entry = null;
            try {
                try {
                    zos = new ZipOutputStream(new BufferedOutputStream(fos, 4096));
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        handler.handleEntry(context);
                        if (context.isEmpty()) break block10;
                        try {
                            name = context.getName().replace(File.separatorChar, '/');
                            entry = new ZipEntry(name);
                            zos.putNextEntry(entry);
                            if (context.isDirectory()) ** GOTO lbl-1000
                            input = context.getInputStream();
                            if (input == null) {
                                throw new IllegalStateException("Input is null for zip entry " + name);
                            }
                            IOUtil.copy(input, (OutputStream)zos, buffer);
                        }
                        finally {
                            IOUtil.closeSilent(input);
                            if (entry != null) {
                                zos.closeEntry();
                            }
                            context.reset();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    throw new IORuntimeException(ex);
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var10_11) {
                IOUtil.closeSilent(zos);
                IOUtil.closeSilent(fos);
                throw var10_11;
            }
        }
        IOUtil.closeSilent(zos);
        IOUtil.closeSilent(fos);
    }

    public static void zip(File sourceFolder, boolean excludeRoot, File zipFile) {
        ZIPUtil.zip(new FileSystemZipHandler(sourceFolder, excludeRoot), zipFile);
    }

    public static void unzip(File zipFile, UnzipHandler handler) throws IORuntimeException {
        FileInputStream fis = IOUtil.openInputStream(zipFile);
        ZipInputStream zis = null;
        try {
            try {
                ZipEntry entry;
                zis = new ZipInputStream(new BufferedInputStream(fis, 4096));
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        handler.unzipDirectory(entry.getName());
                        continue;
                    }
                    handler.unzipFile(entry.getName(), zis);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(zis);
            IOUtil.closeSilent(fis);
            throw throwable;
        }
        IOUtil.closeSilent(zis);
        IOUtil.closeSilent(fis);
    }

    public static void unzip(File zipFile, File targetFolder) throws IORuntimeException {
        URI uri = URI.create("jar:" + String.valueOf(zipFile.toURI()) + "!/");
        final Path targetRoot = targetFolder.toPath();
        Map<String, String> options = Map.of("enablePosixFileAttributes", "true");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, options);){
                final Path jarRoot = fileSystem.getPath("/", new String[0]);
                Files.walkFileTree(jarRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path targetFile = this.getTarget(file);
                        Files.copy(file, targetFile, new CopyOption[0]);
                        this.setPosixFilePermissions(file, targetFile);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path targetDir = this.getTarget(dir);
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                        this.setPosixFilePermissions(dir, targetDir);
                        return FileVisitResult.CONTINUE;
                    }

                    private Path getTarget(Path source) {
                        return targetRoot.resolve(jarRoot.relativize(source).toString());
                    }

                    private void setPosixFilePermissions(Path source, Path target) {
                        try {
                            PosixFileAttributeView sourceFileAttributeView = Files.getFileAttributeView(source, PosixFileAttributeView.class, new LinkOption[0]);
                            PosixFileAttributeView targetFileAttributeView = Files.getFileAttributeView(target, PosixFileAttributeView.class, new LinkOption[0]);
                            if (sourceFileAttributeView != null && targetFileAttributeView != null) {
                                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(source, new LinkOption[0]);
                                Files.setPosixFilePermissions(target, perms);
                            }
                        }
                        catch (IOException | RuntimeException exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static final class EntryContext {
        private static final String EMPTY = new String();
        private String name = EMPTY;
        private InputStream inputStream;
        private boolean directory;

        EntryContext() {
        }

        void reset() {
            this.name = null;
            this.inputStream = null;
        }

        boolean isEmpty() {
            return this.name == null;
        }

        boolean isDirectory() {
            return this.directory;
        }

        String getName() {
            return this.name;
        }

        InputStream getInputStream() {
            return this.inputStream;
        }

        public void setName(String name, boolean directory) {
            this.name = name + (directory ? "/" : "");
            this.directory = directory;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }
    }

    public static class FileSystemUnzipHandler
    implements UnzipHandler {
        private File targetFolder;
        private transient byte[] buffer;

        public FileSystemUnzipHandler(File targetFolder, int bufferSize) {
            this.targetFolder = targetFolder;
            this.buffer = new byte[bufferSize];
        }

        public FileSystemUnzipHandler(File targetFolder) {
            this(targetFolder, 4096);
        }

        public File getTargetFolder() {
            return this.targetFolder;
        }

        @Override
        public void unzipDirectory(String name) {
            File directory = new File(this.targetFolder, name);
            if (!directory.exists()) {
                directory.mkdirs();
            }
        }

        @Override
        public void unzipFile(String name, InputStream zipStream) {
            File targetFile = new File(this.targetFolder, name);
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            FileOutputStream out = IOUtil.openOutputStream(targetFile);
            try {
                IOUtil.copy(zipStream, (OutputStream)out, this.buffer);
            }
            finally {
                IOUtil.closeSilent(out);
            }
        }
    }

    public static class FileSystemZipHandler
    implements ZipEntryHandler {
        private int sourceFolderLength;
        private transient Iterator<File> files;

        public FileSystemZipHandler(File sourceFolder, boolean excludeRoot) {
            File root = excludeRoot ? sourceFolder : sourceFolder.getParentFile();
            this.sourceFolderLength = root.getAbsolutePath().length();
            if (excludeRoot) {
                ++this.sourceFolderLength;
            }
            final int baseLength = sourceFolder.getAbsolutePath().length();
            List<File> list = IOUtil.listBreadthFirst(sourceFolder);
            Collections.sort(list, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    String path1 = this.getPath(f1, baseLength);
                    String path2 = this.getPath(f2, baseLength);
                    if (path1.length() == 0) {
                        return -1;
                    }
                    if (path2.length() == 0) {
                        return 1;
                    }
                    if (f1.isDirectory()) {
                        if (f2.isDirectory()) {
                            if (path1.equalsIgnoreCase("/META-INF")) {
                                return -1;
                            }
                            if (path2.equalsIgnoreCase("/META-INF")) {
                                return 1;
                            }
                            return path1.compareTo(path2);
                        }
                        if (path1.equalsIgnoreCase("/META-INF")) {
                            return -1;
                        }
                        if (path2.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                            return 1;
                        }
                        return -1;
                    }
                    if (f2.isDirectory()) {
                        if (path2.equalsIgnoreCase("/META-INF")) {
                            return 1;
                        }
                        if (path1.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                            return -1;
                        }
                        return 1;
                    }
                    if (path1.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                        return -1;
                    }
                    if (path2.equalsIgnoreCase("/META-INF/MANIFEST.MF")) {
                        return 1;
                    }
                    return path1.compareTo(path2);
                }

                private String getPath(File file, int baseLength2) {
                    String absolutePath = file.getAbsolutePath();
                    String substring = absolutePath.substring(baseLength2);
                    String replace = substring.replace(File.separatorChar, '/');
                    return replace;
                }
            });
            this.files = list.iterator();
            if (excludeRoot) {
                this.files.next();
            }
        }

        @Override
        public void handleEntry(EntryContext context) throws IOException {
            File file;
            String name;
            if (this.files.hasNext() && (name = this.getName(file = this.files.next())).length() != 0) {
                context.setName(name, file.isDirectory());
                if (file.isFile()) {
                    context.setInputStream(IOUtil.openInputStream(file));
                }
            }
        }

        protected String getName(File file) {
            return file.getAbsolutePath().substring(this.sourceFolderLength);
        }
    }

    public static interface UnzipHandler {
        public void unzipDirectory(String var1) throws IOException;

        public void unzipFile(String var1, InputStream var2) throws IOException;
    }

    public static interface ZipEntryHandler {
        public void handleEntry(EntryContext var1) throws IOException;
    }
}

