/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.properties.ApplyModifiersOperation;
import org.eclipse.gmf.runtime.common.ui.services.properties.GetPropertySourceOperation;
import org.eclipse.gmf.runtime.common.ui.services.properties.ICompositePropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.IPropertiesProvider;
import org.eclipse.gmf.runtime.common.ui.services.properties.internal.PSFCommonUIPlugin;
import org.osgi.framework.Bundle;

public class PropertiesService
extends Service
implements IPropertiesProvider {
    private static final String E_MODIFIER_PROVIDER = "Provider";
    private static final String A_CLASS = "class";
    private static final String STAR = "*";
    private static PropertiesService uniqueInstance;
    private Map modifiersServices = new HashMap();
    private Map modifiersMap = new HashMap();
    private static final String PROPERTY_PROVIDERS_EXT_P_NAME = "propertiesProviders";
    private static final String PROPERTY_MODIFIERS_EXT_P_NAME = "propertyModifiers";

    public static PropertiesService getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new PropertiesService();
        }
        return uniqueInstance;
    }

    private PropertiesService() {
        String pluginId = PSFCommonUIPlugin.getPluginId();
        this.configureProviders(pluginId, PROPERTY_PROVIDERS_EXT_P_NAME);
        this.configureModifiers(Platform.getExtensionRegistry().getExtensionPoint(pluginId, PROPERTY_MODIFIERS_EXT_P_NAME).getConfigurationElements());
    }

    @Override
    public ICompositePropertySource getPropertySource(Object object) {
        GetPropertySourceOperation operation = new GetPropertySourceOperation(object);
        this.execute(ExecutionStrategy.FORWARD, operation);
        return operation.getPropertySource();
    }

    public void applyModifiers(IPropertiesProvider provider, ICompositePropertySource propertySource) {
        ModifiersService modifiersService = this.getModifiersService(provider);
        if (modifiersService != null) {
            modifiersService.applyModifiers(propertySource);
        }
    }

    protected ModifiersService getModifiersService(IPropertiesProvider provider) {
        return (ModifiersService)((Object)this.modifiersServices.get(provider.getClass().getName()));
    }

    public final void configureModifiers(IConfigurationElement[] elements) {
        ArrayList<IConfigurationElement> modifiersApplicableForAllProviders = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            IConfigurationElement[] associatedProviders = element.getChildren(E_MODIFIER_PROVIDER);
            int p = 0;
            while (p < associatedProviders.length) {
                IConfigurationElement associatedProvider = associatedProviders[p];
                String providerId = associatedProvider.getAttribute(A_CLASS);
                if (providerId.equals(STAR)) {
                    modifiersApplicableForAllProviders.add(element);
                } else {
                    if (!this.modifiersMap.containsKey(providerId)) {
                        this.modifiersMap.put(providerId, new ArrayList());
                    }
                    ((List)this.modifiersMap.get(providerId)).add(element);
                }
                ++p;
            }
            ++i;
        }
        for (String providerId : this.modifiersMap.keySet()) {
            ArrayList modifierElements = (ArrayList)this.modifiersMap.get(providerId);
            modifierElements.addAll(modifiersApplicableForAllProviders);
            int modifiersForProvider = modifierElements.size();
            if (modifiersForProvider <= 0) continue;
            IConfigurationElement[] elementsArray = new IConfigurationElement[modifiersForProvider];
            System.arraycopy(modifierElements.toArray(), 0, elementsArray, 0, modifierElements.size());
            this.initModifierServiceFor(providerId, elementsArray);
        }
    }

    private void initModifierServiceFor(String providerId, IConfigurationElement[] modifierElements) {
        ModifiersService modifierService = new ModifiersService();
        modifierService.configureProviders(modifierElements);
        this.modifiersServices.put(providerId, modifierService);
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        String providerId = element.getAttribute(A_CLASS);
        this.modifiersMap.put(providerId, new ArrayList());
        return new PropertiesProviderDescriptor(element);
    }

    static class ModifiersService
    extends Service {
        public ICompositePropertySource applyModifiers(ICompositePropertySource propertySource) {
            ApplyModifiersOperation operation = new ApplyModifiersOperation(propertySource);
            this.execute(ExecutionStrategy.FORWARD, operation);
            return operation.getPropertySource();
        }
    }

    protected static class PropertiesProviderDescriptor
    extends Service.ProviderDescriptor {
        private static final String A_PLUGIN_LOADED = "verifyPluginLoaded";

        protected PropertiesProviderDescriptor(IConfigurationElement element) {
            super(element);
        }

        public boolean provides(IOperation operation) {
            String attr_value = this.getElement().getAttribute(A_PLUGIN_LOADED);
            Boolean pluginLoadedVerify = Boolean.valueOf(attr_value);
            if (pluginLoadedVerify.booleanValue() && !this.isPluginLoaded()) {
                return false;
            }
            IProvider theProvider = this.getProvider();
            return theProvider != null && theProvider.provides(operation);
        }

        private boolean isPluginLoaded() {
            String pluginId = ((IExtension)this.getElement().getParent()).getContributor().getName();
            Bundle bundle = Platform.getBundle((String)pluginId);
            return bundle != null && bundle.getState() == 32;
        }
    }
}

