/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.helper;

import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeCreationDescriptionQuery;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.tools.internal.command.builders.EdgeCreationCommandBuilder;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public final class CreateConnectionRequestHelper {
    private CreateConnectionRequestHelper() {
    }

    public static boolean computeConnectionStartExtendedData(CreateConnectionRequest request, INodeEditPart connectableEditPart) {
        AbstractToolDescription abstractToolDescription;
        View view;
        Map extendedData = request.getExtendedData();
        ConnectionAnchor sourceAnchor = connectableEditPart.getSourceConnectionAnchor((Request)request);
        String newSourceTerminal = connectableEditPart.mapConnectionAnchorToTerminal(sourceAnchor);
        Point sourceLocation = CreateConnectionRequestHelper.getConvertedLocation(request.getLocation().getCopy(), (EditPart)connectableEditPart, false);
        extendedData.put("edge.location.source", sourceLocation.getCopy());
        extendedData.put("edge.newSourceTerminal", newSourceTerminal);
        INodeEditPart graphicalEditPart = connectableEditPart;
        DSemanticDecorator decorateSemanticElement = null;
        if (graphicalEditPart.getModel() instanceof View && (view = (View)graphicalEditPart.getModel()).getElement() instanceof DSemanticDecorator) {
            decorateSemanticElement = (DSemanticDecorator)view.getElement();
        }
        if (decorateSemanticElement instanceof EdgeTarget && request.getNewObject() instanceof AbstractToolDescription && (abstractToolDescription = (AbstractToolDescription)request.getNewObject()) instanceof EdgeCreationDescription) {
            EdgeCreationDescription edgeCreationDescription = (EdgeCreationDescription)abstractToolDescription;
            boolean canCreate = new EdgeCreationDescriptionQuery(edgeCreationDescription).isValidAsSourceElement((DMappingBased)decorateSemanticElement);
            boolean bl = canCreate = canCreate && new EdgeCreationCommandBuilder(edgeCreationDescription, (EdgeTarget)decorateSemanticElement, null).checkStartPrecondition();
            if (canCreate) {
                extendedData.put("edge.creation.description", edgeCreationDescription);
                extendedData.put("edgeTarget.source", decorateSemanticElement);
                return true;
            }
        }
        return false;
    }

    private static Point getConvertedLocation(Point pointToConvert, EditPart referencePart, boolean feedbackCoordinates) {
        Point realLocation;
        if (pointToConvert != null && referencePart instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)referencePart).getFigure();
            if (feedbackCoordinates) {
                pointToConvert.translate(GraphicalHelper.getScrollSize((GraphicalEditPart)((GraphicalEditPart)referencePart)).negate());
            }
            fig.translateToRelative((Translatable)pointToConvert);
            Point containerLocation = fig.getBounds().getLocation();
            realLocation = new Point(pointToConvert.x - containerLocation.x, pointToConvert.y - containerLocation.y);
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                realLocation = new Point(realLocation.x + scrollOffset.x, realLocation.y + scrollOffset.y);
            }
        } else {
            realLocation = pointToConvert;
        }
        return realLocation;
    }
}

