/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.SecretSpec;

final class ImmutableSecretSpec
implements SecretSpec {
    private final String name;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final String data;

    private ImmutableSecretSpec(String name, @Nullable Map<String, String> labels, @Nullable String data) {
        this.name = name;
        this.labels = labels;
        this.data = data;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Data")
    @Nullable
    public String data() {
        return this.data;
    }

    public final ImmutableSecretSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSecretSpec(newValue, this.labels, this.data);
    }

    public final ImmutableSecretSpec withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableSecretSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableSecretSpec(this.name, newValue, this.data);
    }

    public final ImmutableSecretSpec withData(@Nullable String value) {
        if (Objects.equals(this.data, value)) {
            return this;
        }
        return new ImmutableSecretSpec(this.name, this.labels, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretSpec && this.equalsByValue((ImmutableSecretSpec)another);
    }

    private boolean equalsByValue(ImmutableSecretSpec another) {
        return this.name.equals(another.name) && Objects.equals(this.labels, another.labels) && Objects.equals(this.data, another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.data);
        return h;
    }

    public String toString() {
        return "SecretSpec{name=" + this.name + ", labels=" + String.valueOf(this.labels) + ", data=" + this.data + "}";
    }

    public static ImmutableSecretSpec copyOf(SecretSpec instance) {
        if (instance instanceof ImmutableSecretSpec) {
            return (ImmutableSecretSpec)instance;
        }
        return ImmutableSecretSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements SecretSpec.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private Map<String, String> labels = null;
        private String data;

        private Builder() {
        }

        public final Builder from(SecretSpec instance) {
            String dataValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Map<String, String> labelsValue = instance.labels();
            if (labelsValue != null) {
                this.putAllLabels(labelsValue);
            }
            if ((dataValue = instance.data()) != null) {
                this.data(dataValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Data")
        public final Builder data(@Nullable String data) {
            this.data = data;
            return this;
        }

        @Override
        public ImmutableSecretSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecretSpec(this.name, this.labels == null ? null : ImmutableSecretSpec.createUnmodifiableMap(false, false, this.labels), this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build SecretSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

