/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ReferenceMethod;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.inject.ValueUtils;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.inject.methods.BaseMethod;
import org.apache.felix.scr.impl.inject.methods.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.osgi.framework.BundleContext;

public class BindMethod
extends BaseMethod<BindParameters, List<ValueUtils.ValueType>>
implements ReferenceMethod {
    private final String m_referenceClassName;
    private volatile List<ValueUtils.ValueType> m_paramTypes = Collections.emptyList();

    public BindMethod(String methodName, Class<?> componentClass, String referenceClassName, DSVersion dsVersion, boolean configurableServiceProperties) {
        super(methodName, methodName != null, componentClass, dsVersion, configurableServiceProperties);
        this.m_referenceClassName = referenceClassName;
    }

    @Override
    protected BaseMethod.MethodInfo<List<ValueUtils.ValueType>> doFindMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        Class<?> parameterClass;
        Method method;
        boolean suitableMethodNotAccessible = false;
        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Looking for method " + targetClass.getName() + "." + this.getMethodName(), null);
        }
        try {
            method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage, logger);
            if (method != null) {
                if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                    logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                }
                return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceReference));
            }
        }
        catch (SuitableMethodNotAccessibleException ex) {
            suitableMethodNotAccessible = true;
        }
        if (this.getDSVersion().isDS13()) {
            try {
                method = this.getComponentObjectsMethod(targetClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                        logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                    }
                    return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceObjects));
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
        }
        if ((parameterClass = ClassUtils.getClassFromComponentClassLoader(targetClass, this.m_referenceClassName, logger)) != null) {
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "doFindMethod: No method taking ServiceReference found, checking method taking " + parameterClass.getName(), null);
            }
            try {
                method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                        logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                    }
                    return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceType));
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            try {
                method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                        logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                    }
                    return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_serviceType));
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            if (this.getDSVersion().isDS13()) {
                try {
                    method = this.getMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                        }
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, Collections.singletonList(ValueUtils.ValueType.ref_map));
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
            if (this.getDSVersion().isDS11() && !this.getDSVersion().isDS13()) {
                ArrayList<ValueUtils.ValueType> paramTypes;
                try {
                    method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage, logger);
                    if (method != null) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                        }
                        paramTypes = new ArrayList<ValueUtils.ValueType>(2);
                        paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                        paramTypes.add(ValueUtils.ValueType.ref_map);
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, paramTypes);
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + method, null);
                        }
                        paramTypes = new ArrayList(2);
                        paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                        paramTypes.add(ValueUtils.ValueType.ref_map);
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(method, paramTypes);
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
            if (this.getDSVersion().isDS13()) {
                for (Method m : targetClass.getDeclaredMethods()) {
                    if (!this.getMethodName().equals(m.getName())) continue;
                    Class<?>[] parameterTypes = m.getParameterTypes();
                    boolean matches = true;
                    boolean specialMatch = true;
                    ArrayList<ValueUtils.ValueType> paramTypes = new ArrayList<ValueUtils.ValueType>(parameterTypes.length);
                    for (Class<?> paramType : parameterTypes) {
                        if (paramType == ClassUtils.SERVICE_REFERENCE_CLASS) {
                            if (specialMatch && parameterClass == ClassUtils.SERVICE_REFERENCE_CLASS) {
                                specialMatch = false;
                                paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                continue;
                            }
                            paramTypes.add(ValueUtils.ValueType.ref_serviceReference);
                            continue;
                        }
                        if (paramType == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                            if (specialMatch && parameterClass == ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS) {
                                specialMatch = false;
                                paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                continue;
                            }
                            paramTypes.add(ValueUtils.ValueType.ref_serviceObjects);
                            continue;
                        }
                        if (paramType == ClassUtils.MAP_CLASS) {
                            if (specialMatch && parameterClass == ClassUtils.MAP_CLASS) {
                                specialMatch = false;
                                paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                                continue;
                            }
                            paramTypes.add(ValueUtils.ValueType.ref_map);
                            continue;
                        }
                        if (paramType.isAssignableFrom(parameterClass)) {
                            paramTypes.add(ValueUtils.ValueType.ref_serviceType);
                            continue;
                        }
                        if (this.getDSVersion().isDS14() && "org.osgi.service.log.LoggerFactory".equals(this.m_referenceClassName)) {
                            if (paramType.getName().equals("org.osgi.service.log.Logger")) {
                                paramTypes.add(ValueUtils.ValueType.ref_logger);
                                continue;
                            }
                            if (paramType.getName().equals("org.osgi.service.log.FormatterLogger")) {
                                paramTypes.add(ValueUtils.ValueType.ref_formatterLogger);
                                continue;
                            }
                            matches = false;
                            break;
                        }
                        matches = false;
                        break;
                    }
                    if (!matches) continue;
                    if (BindMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                            logger.log(InternalLogger.Level.DEBUG, "doFindMethod: Found Method " + m, null);
                        }
                        return new BaseMethod.MethodInfo<List<ValueUtils.ValueType>>(m, paramTypes);
                    }
                    suitableMethodNotAccessible = true;
                }
            }
        } else if (logger.isLogEnabled(InternalLogger.Level.WARN)) {
            logger.log(InternalLogger.Level.WARN, "doFindMethod: Cannot check for methods taking parameter class " + this.m_referenceClassName + ": " + targetClass.getName() + " does not see it", null);
        }
        if (suitableMethodNotAccessible) {
            logger.log(InternalLogger.Level.ERROR, "doFindMethod: Suitable but non-accessible method found in class {0}", null, targetClass.getName());
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    @Override
    protected void setTypes(List<ValueUtils.ValueType> types) {
        this.m_paramTypes = types;
    }

    private Method getServiceReferenceMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getComponentObjectsMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.COMPONENTS_SERVICE_OBJECTS_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Checking " + candidateBindMethods.length + " declared method in class " + targetClass.getName(), null);
        }
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Class<?> theParameter;
            Class<?>[] parameters;
            Method method = candidateBindMethods[i];
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Checking " + method, null);
            }
            if ((parameters = method.getParameterTypes()).length != 1 || !method.getName().equals(this.getMethodName())) continue;
            if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Considering " + method, null);
            }
            if ((theParameter = parameters[0]).isAssignableFrom(parameterClass)) {
                if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                    return method;
                }
                suitableNotAccessible = true;
                continue;
            }
            if (!logger.isLogEnabled(InternalLogger.Level.DEBUG)) continue;
            logger.log(InternalLogger.Level.DEBUG, "getServiceObjectAssignableMethod: Parameter failure: Required " + theParameter + "; actual " + parameterClass.getName(), null);
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, ClassUtils.MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 2 || !method.getName().equals(this.getMethodName()) || !parameters[0].isAssignableFrom(parameterClass) || parameters[1] != ClassUtils.MAP_CLASS) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getMapMethod(Class<?> targetClass, Class<?> parameterClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.MAP_CLASS}, acceptPrivate, acceptPackage, logger);
    }

    @Override
    public <S, T> boolean getServiceObject(BindParameters parameters, BundleContext context) {
        if (parameters.getRefPair().getServiceObject(parameters.getComponentContext()) == null && this.methodExists(parameters.getComponentContext().getLogger()) && (this.m_paramTypes.contains((Object)ValueUtils.ValueType.ref_serviceType) || this.m_paramTypes.contains((Object)ValueUtils.ValueType.ref_logger) || this.m_paramTypes.contains((Object)ValueUtils.ValueType.ref_formatterLogger))) {
            return parameters.getRefPair().getServiceObject(parameters.getComponentContext(), context);
        }
        return true;
    }

    @Override
    protected Object[] getParameters(Method method, BindParameters bp) {
        ScrComponentContext key = bp.getComponentContext();
        Object[] result = new Object[this.m_paramTypes.size()];
        RefPair<?, ?> refPair = bp.getRefPair();
        int i = 0;
        for (ValueUtils.ValueType pt : this.m_paramTypes) {
            result[i] = ValueUtils.getValue(this.getComponentClass().getName(), pt, method.getParameterTypes()[i], key, refPair, null);
            ++i;
        }
        return result;
    }

    @Override
    protected String getMethodNamePrefix() {
        return "bind";
    }
}

