/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;

public class DateArraySeriesModel
extends DoubleArraySeriesModel {
    private LocalDate[] localDates;
    private Date[] dates;

    public DateArraySeriesModel(Date[] dates, double[] ySeries) {
        super(DateArraySeriesModel.toXSeriesArray(dates), ySeries);
        this.dates = dates;
    }

    public DateArraySeriesModel(LocalDate[] dates, double[] ySeries, ZoneOffset zoneOffset) {
        super(DateArraySeriesModel.toXSeriesArray(dates, zoneOffset), ySeries);
        this.localDates = dates;
    }

    private static double[] toXSeriesArray(Date[] dates) {
        double[] xSeries = new double[dates.length];
        int i = 0;
        while (i < xSeries.length) {
            xSeries[i] = dates[i].getTime();
            ++i;
        }
        return xSeries;
    }

    public Date dateAt(int index) {
        return this.dates[index];
    }

    private static double[] toXSeriesArray(LocalDate[] dates, ZoneOffset zoneOffset) {
        double[] xSeries = new double[dates.length];
        int i = 0;
        while (i < xSeries.length) {
            xSeries[i] = dates[i].atStartOfDay().toEpochSecond(zoneOffset);
            ++i;
        }
        return xSeries;
    }

    public LocalDate localDateAt(int index) {
        return this.localDates[index];
    }
}

