/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.Optional;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.ui.search.LRUWorkingSets;
import org.eclipse.ui.IWorkingSet;

public class CSearchUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSets workingSetsCache;

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        CSearchUtil.getLRUWorkingSets().add(workingSets);
    }

    public static LRUWorkingSets getLRUWorkingSets() {
        if (workingSetsCache == null) {
            workingSetsCache = new LRUWorkingSets(LRU_WORKINGSET_LIST_SIZE);
        }
        return workingSetsCache;
    }

    public static String toString(IWorkingSet[] workingSets) {
        if (workingSets != null && workingSets.length > 0) {
            Object string = "";
            int i = 0;
            while (i < workingSets.length) {
                if (i > 0) {
                    string = (String)string + ", ";
                }
                string = (String)string + workingSets[i].getName();
                ++i;
            }
            return string;
        }
        return null;
    }

    public static boolean isWriteOccurrence(IASTName node, IBinding binding) {
        Optional res;
        boolean isWrite = binding instanceof ICPPVariable ? !(res = CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)node)).isPresent() || ((Integer)res.get() & 0x40) != 0 : !(res = CVariableReadWriteFlags.getReadWriteFlags((IASTName)node)).isPresent() || ((Integer)res.get() & 0x40) != 0;
        return isWrite;
    }

    private static boolean isOperatorChar(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '<': 
            case '=': 
            case '>': 
            case '[': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static String adjustSearchStringForOperators(String searchStr) {
        int operatorCharIndex;
        int operatorIndex = ((String)searchStr).indexOf("operator");
        if (operatorIndex >= 0 && (operatorCharIndex = operatorIndex + 8) < ((String)searchStr).length() && CSearchUtil.isOperatorChar(((String)searchStr).charAt(operatorCharIndex))) {
            searchStr = ((String)searchStr).substring(0, operatorCharIndex) + " " + ((String)searchStr).substring(operatorCharIndex);
        }
        return searchStr;
    }
}

