/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.cdt.internal.ui.refactoring.reorg.RefactoringModifications;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class RenameModifications
extends RefactoringModifications {
    private List<Object> fRename = new ArrayList<Object>();
    private List<RefactoringArguments> fRenameArguments = new ArrayList<RefactoringArguments>();
    private List<IParticipantDescriptorFilter> fParticipantDescriptorFilter = new ArrayList<IParticipantDescriptorFilter>();

    public void rename(IBinding binding, RenameArguments args) {
        this.add(binding, (RefactoringArguments)args, null);
    }

    public void rename(IResource resource, RenameArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void rename(ISourceRoot sourceFolder, RenameArguments arguments) {
        this.add(sourceFolder, (RefactoringArguments)arguments, null);
        if (sourceFolder.getResource() != null) {
            this.getResourceModifications().addRename((IResource)sourceFolder.getResource(), arguments);
        }
    }

    public void rename(ITranslationUnit unit, RenameArguments args) {
        this.add(unit, (RefactoringArguments)args, null);
        if (unit.getResource() != null) {
            this.getResourceModifications().addRename(unit.getResource(), new RenameArguments(args.getNewName(), args.getUpdateReferences()));
        }
    }

    @Override
    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fRename.size()) {
            Object element = this.fRename.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildMoveDelta(builder, (IResource)element, (RenameArguments)this.fRenameArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    @Override
    public void buildValidateEdits(ValidateEditChecker checker) {
        for (Object element : this.fRename) {
            ITranslationUnit unit;
            IResource resource;
            if (!(element instanceof ITranslationUnit) || (resource = (unit = (ITranslationUnit)element).getResource()) == null || resource.getType() != 1) continue;
            checker.addFile((IFile)resource);
        }
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.fRename.size()) {
            ArrayUtil.addAll(result, (Object[])ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, (Object)this.fRename.get(i), (RenameArguments)((RenameArguments)this.fRenameArguments.get(i)), (IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i), (String[])natures, (SharableParticipants)shared));
            ++i;
        }
        ArrayUtil.addAll(result, (Object[])this.getResourceModifications().getParticipants(status, owner, natures, shared));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fRename.add(element);
        this.fRenameArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }
}

