/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.Messages;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.Method;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.OverrideMethodsRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodContainer;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodPrintData;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class OverrideMethodsInputPage
extends UserInputWizardPage {
    private OverrideMethodsRefactoring fRefactoring;
    private CheckboxTreeViewer fTree;

    public OverrideMethodsInputPage(OverrideMethodsRefactoring refactoring) {
        super(Messages.OverrideMethodsInputPage_Name);
        this.fRefactoring = refactoring;
    }

    private Composite createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 4;
        buttonComposite.setLayout((Layout)layout);
        Button selAllButton = new Button(buttonComposite, 8);
        selAllButton.setText(Messages.OverrideMethodsInputPage_SelectAll);
        selAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Method> allMethods = OverrideMethodsInputPage.this.fRefactoring.getMethodContainer().getAllMethods();
                OverrideMethodsInputPage.this.fTree.setCheckedElements(allMethods.toArray());
                OverrideMethodsInputPage.this.fRefactoring.getPrintData().addMethods(allMethods);
                OverrideMethodsInputPage.this.checkPageComplete();
            }
        });
        Button deselAllButton = new Button(buttonComposite, 8);
        deselAllButton.setText(Messages.OverrideMethodsInputPage_DeselectAll);
        deselAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Method> allMethods = OverrideMethodsInputPage.this.fRefactoring.getMethodContainer().getAllMethods();
                for (Method method : allMethods) {
                    OverrideMethodsInputPage.this.fTree.setChecked((Object)method, false);
                }
                OverrideMethodsInputPage.this.fRefactoring.getPrintData().removeMethods(allMethods);
                OverrideMethodsInputPage.this.checkPageComplete();
            }
        });
        return buttonComposite;
    }

    private void createTree(Composite parent) {
        this.fTree = new ContainerCheckedTreeViewer(parent);
        this.fTree.setContentProvider((IContentProvider)this.fRefactoring.getMethodContainer());
        this.fTree.setAutoExpandLevel(3);
        this.fTree.setInput(this.fRefactoring.getMethodContainer().getInitialInput());
        this.fTree.getTree().setLayoutData((Object)new GridData(1808));
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                VirtualMethodPrintData printData = OverrideMethodsInputPage.this.fRefactoring.getPrintData();
                if (event.getElement() instanceof ICPPClassType) {
                    ICPPClassType parentClass = (ICPPClassType)event.getElement();
                    VirtualMethodContainer methodContainer = OverrideMethodsInputPage.this.fRefactoring.getMethodContainer();
                    List<Method> selectedMethods = methodContainer.getMethods(parentClass);
                    if (event.getChecked()) {
                        printData.addMethods(selectedMethods);
                    } else {
                        printData.removeMethods(selectedMethods);
                    }
                } else if (event.getElement() instanceof Method) {
                    Method selectedMethod = (Method)event.getElement();
                    if (event.getChecked()) {
                        printData.addMethod(selectedMethod);
                    } else {
                        printData.removeMethod(selectedMethod);
                    }
                }
                OverrideMethodsInputPage.this.checkPageComplete();
            }
        });
        for (Method method : this.fRefactoring.getMethodContainer().getAllMethods()) {
            this.fTree.setChecked((Object)method, false);
        }
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.OverrideMethodsInputPage_Name);
        this.setMessage(Messages.OverrideMethodsInputPage_Header);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.createTree(comp);
        GridData gd = new GridData(1808);
        this.fTree.getTree().setLayoutData((Object)gd);
        Composite buttonContainer = this.createButtons(comp);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonContainer.setLayoutData((Object)gd);
        final Button ignoreVirtual = new Button(comp, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.heightHint = 20;
        ignoreVirtual.setLayoutData((Object)gd);
        ignoreVirtual.setText(Messages.OverrideMethodsRefactoring_PreserveVirtual);
        ignoreVirtual.setSelection(this.fRefactoring.getOptions().preserveVirtual());
        ignoreVirtual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideMethodsInputPage.this.fRefactoring.getOptions().setPreserveVirtual(ignoreVirtual.getSelection());
            }
        });
        final Button addOverridden = new Button(comp, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.heightHint = 40;
        addOverridden.setLayoutData((Object)gd);
        addOverridden.setText(Messages.OverrideMethodsRefactoring_AddOverride);
        addOverridden.setSelection(this.fRefactoring.getOptions().addOverride());
        addOverridden.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideMethodsInputPage.this.fRefactoring.getOptions().setAddOverride(addOverridden.getSelection());
            }
        });
        Link link = new Link(comp, 64);
        link.setText(Messages.OverrideMethodsRefactoring_LinkDescription);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)OverrideMethodsInputPage.this.getShell(), (String)"org.eclipse.cdt.ui.preferences.CodeStylePreferencePage", (String[])new String[]{"org.eclipse.cdt.ui.preferences.CodeStylePreferencePage"}, null).open();
            }
        });
        link.setToolTipText(Messages.OverrideMethodsRefactoring_LinkTooltip);
        gd = new GridData(4, 0x1000000, true, false);
        gd.grabExcessHorizontalSpace = true;
        link.setLayoutData((Object)gd);
        this.checkPageComplete();
        this.setControl((Control)comp);
    }

    private void checkPageComplete() {
        if (this.fRefactoring.getPrintData().isEmpty()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }
}

