/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.codemanipulation;

import java.text.Collator;

public class IncludeInfo
implements Comparable<IncludeInfo> {
    private static final Collator COLLATOR = Collator.getInstance();
    private final String name;
    private final boolean isSystem;

    public IncludeInfo(String name, boolean isSystem) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.isSystem = isSystem;
    }

    public IncludeInfo(String includeText) {
        if (includeText == null || includeText.isEmpty()) {
            throw new IllegalArgumentException();
        }
        boolean isSystem = false;
        int begin = 0;
        switch (includeText.charAt(0)) {
            case '<': {
                isSystem = true;
            }
            case '\"': {
                ++begin;
            }
        }
        int end = includeText.length();
        switch (includeText.charAt(end - 1)) {
            case '\"': 
            case '>': {
                --end;
            }
        }
        if (begin >= end) {
            throw new IllegalArgumentException();
        }
        this.name = includeText.substring(begin, end);
        this.isSystem = isSystem;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isSystem() {
        return this.isSystem;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + (this.isSystem ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeInfo other = (IncludeInfo)obj;
        return this.name.equals(other.name) && this.isSystem == other.isSystem;
    }

    public String toString() {
        return (this.isSystem ? (char)'<' : '\"') + this.name + (this.isSystem ? (char)'>' : '\"');
    }

    public String composeIncludeStatement() {
        return "#include " + this.toString();
    }

    @Override
    public int compareTo(IncludeInfo other) {
        if (this.isSystem != other.isSystem) {
            return this.isSystem ? -1 : 1;
        }
        int length1 = this.name.length();
        int length2 = other.name.length();
        int i = 0;
        while (i < length1 && i < length2) {
            int c;
            int o2;
            char c1 = this.name.charAt(i);
            char c2 = other.name.charAt(i);
            int o1 = this.order(c1);
            if (o1 != (o2 = this.order(c2))) {
                return o1 - o2;
            }
            if (o1 == 0 && (c = COLLATOR.compare(String.valueOf(c1), String.valueOf(c2))) != 0) {
                return c;
            }
            ++i;
        }
        return length1 - length2;
    }

    private int order(char c) {
        switch (c) {
            case '/': {
                return -3;
            }
            case '\\': {
                return -2;
            }
            case '.': {
                return -1;
            }
        }
        return 0;
    }
}

