/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalEnumerationSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;

public class CASTEnumerationSpecifier
extends CASTBaseDeclSpecifier
implements IASTInternalEnumerationSpecifier,
ICASTEnumerationSpecifier {
    private IASTName fName;
    private Boolean fValuesComputed;
    private IASTEnumerationSpecifier.IASTEnumerator[] fEnumerators = IASTEnumerationSpecifier.IASTEnumerator.EMPTY_ENUMERATOR_ARRAY;
    private int fNumEnumerators;

    public CASTEnumerationSpecifier() {
    }

    public CASTEnumerationSpecifier(IASTName name) {
        this.setName(name);
    }

    @Override
    public CASTEnumerationSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTEnumerationSpecifier copy(IASTNode.CopyStyle style) {
        CASTEnumerationSpecifier copy = new CASTEnumerationSpecifier();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CASTEnumerationSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setName(this.fName == null ? null : this.fName.copy(style));
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = this.getEnumerators();
        int n = iASTEnumeratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
            copy.addEnumerator(enumerator == null ? null : enumerator.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public boolean startValueComputation() {
        if (this.fValuesComputed != null) {
            return false;
        }
        this.fValuesComputed = Boolean.FALSE;
        return true;
    }

    @Override
    public void finishValueComputation() {
        this.fValuesComputed = Boolean.TRUE;
    }

    @Override
    public boolean isValueComputationInProgress() {
        return this.fValuesComputed != null && this.fValuesComputed == false;
    }

    @Override
    public void addEnumerator(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.assertNotFrozen();
        if (enumerator != null) {
            enumerator.setParent(this);
            enumerator.setPropertyInParent(ENUMERATOR);
            this.fEnumerators = ArrayUtil.appendAt(this.fEnumerators, this.fNumEnumerators++, enumerator);
        }
    }

    @Override
    public IASTEnumerationSpecifier.IASTEnumerator[] getEnumerators() {
        this.fEnumerators = ArrayUtil.trim(this.fEnumerators, this.fNumEnumerators);
        return this.fEnumerators;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ENUMERATION_NAME);
        }
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.visitAlignmentSpecifiers(action)) {
            return false;
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        IASTEnumerationSpecifier.IASTEnumerator[] etors = this.getEnumerators();
        int i = 0;
        while (i < etors.length) {
            if (!etors[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.fName == n) {
            return 2;
        }
        return 3;
    }
}

