/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommentContainer;
import org.eclipse.mylyn.reviews.core.model.IDated;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public class Comment
extends EObjectImpl
implements IComment {
    protected static final long INDEX_EDEFAULT = 0L;
    protected static final Date CREATION_DATE_EDEFAULT = null;
    protected Date creationDate = CREATION_DATE_EDEFAULT;
    protected static final Date MODIFICATION_DATE_EDEFAULT = null;
    protected Date modificationDate = MODIFICATION_DATE_EDEFAULT;
    protected IUser author;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected EList<IComment> replies;
    protected static final boolean DRAFT_EDEFAULT = false;
    protected boolean draft = false;
    protected EList<ILocation> locations;
    protected IReview review;
    protected static final String TITLE_EDEFAULT = null;
    protected String title = TITLE_EDEFAULT;
    protected static final boolean MINE_EDEFAULT = false;

    protected Comment() {
    }

    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.COMMENT;
    }

    @Override
    public long getIndex() {
        long index = Long.MAX_VALUE;
        for (ILocation location : this.getLocations()) {
            index = Math.min(index, location.getIndex());
        }
        return index;
    }

    @Override
    public IUser getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(IUser newAuthor) {
        IUser oldAuthor = this.author;
        this.author = newAuthor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldAuthor, (Object)this.author));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date newCreationDate) {
        Date oldCreationDate = this.creationDate;
        this.creationDate = new Date(newCreationDate.getTime());
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCreationDate, (Object)this.creationDate));
        }
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date newModificationDate) {
        Date oldModificationDate = this.modificationDate;
        this.modificationDate = new Date(newModificationDate.getTime());
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldModificationDate, (Object)this.modificationDate));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public List<IComment> getReplies() {
        if (this.replies == null) {
            this.replies = new EObjectResolvingEList(IComment.class, (InternalEObject)this, 6);
        }
        return this.replies;
    }

    @Override
    public boolean isDraft() {
        return this.draft;
    }

    @Override
    public void setDraft(boolean newDraft) {
        boolean oldDraft = this.draft;
        this.draft = newDraft;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldDraft, this.draft));
        }
    }

    @Override
    public List<ILocation> getLocations() {
        if (this.locations == null) {
            this.locations = new EObjectContainmentEList.Resolving(ILocation.class, (InternalEObject)this, 8);
        }
        return this.locations;
    }

    @Override
    public IReview getReview() {
        if (this.getItem() instanceof IReview) {
            return (IReview)this.getItem();
        }
        if (this.getItem() instanceof IReviewItem) {
            return ((IReviewItem)this.getItem()).getReview();
        }
        return this.review;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldTitle, (Object)this.title));
        }
    }

    @Override
    public ICommentContainer getItem() {
        if (this.eContainerFeatureID() != 11) {
            return null;
        }
        return (ICommentContainer)this.eContainer();
    }

    public ICommentContainer basicGetItem() {
        if (this.eContainerFeatureID() != 11) {
            return null;
        }
        return (ICommentContainer)this.eInternalContainer();
    }

    public NotificationChain basicSetItem(ICommentContainer newItem, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newItem, 11, msgs);
        return msgs;
    }

    @Override
    public void setItem(ICommentContainer newItem) {
        if (newItem != this.eInternalContainer() || this.eContainerFeatureID() != 11 && newItem != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newItem)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newItem != null) {
                msgs = ((InternalEObject)newItem).eInverseAdd((InternalEObject)this, 1, ICommentContainer.class, msgs);
            }
            if ((msgs = this.basicSetItem(newItem, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newItem, (Object)newItem));
        }
    }

    @Override
    public boolean isMine() {
        IRepository repos;
        IRepository iRepository = repos = this.getReview() != null ? this.getReview().getRepository() : null;
        return this.getAuthor() != null && repos != null && (repos.getAccount() == this.getAuthor() || repos.getAccount() != null && repos.getAccount().getEmail() != null && repos.getAccount().getEmail().equals(this.getAuthor().getEmail()));
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetItem((ICommentContainer)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getLocations()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetItem(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 11: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, ICommentContainer.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getIndex();
            }
            case 1: {
                return this.getCreationDate();
            }
            case 2: {
                return this.getModificationDate();
            }
            case 3: {
                return this.getAuthor();
            }
            case 4: {
                return this.getDescription();
            }
            case 5: {
                return this.getId();
            }
            case 6: {
                return this.getReplies();
            }
            case 7: {
                return this.isDraft();
            }
            case 8: {
                return this.getLocations();
            }
            case 9: {
                return this.getReview();
            }
            case 10: {
                return this.getTitle();
            }
            case 11: {
                if (resolve) {
                    return this.getItem();
                }
                return this.basicGetItem();
            }
            case 12: {
                return this.isMine();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setCreationDate((Date)newValue);
                return;
            }
            case 2: {
                this.setModificationDate((Date)newValue);
                return;
            }
            case 3: {
                this.setAuthor((IUser)newValue);
                return;
            }
            case 4: {
                this.setDescription((String)newValue);
                return;
            }
            case 5: {
                this.setId((String)newValue);
                return;
            }
            case 6: {
                this.getReplies().clear();
                this.getReplies().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setDraft((Boolean)newValue);
                return;
            }
            case 8: {
                this.getLocations().clear();
                this.getLocations().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setTitle((String)newValue);
                return;
            }
            case 11: {
                this.setItem((ICommentContainer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setCreationDate(CREATION_DATE_EDEFAULT);
                return;
            }
            case 2: {
                this.setModificationDate(MODIFICATION_DATE_EDEFAULT);
                return;
            }
            case 3: {
                this.setAuthor(null);
                return;
            }
            case 4: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 5: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 6: {
                this.getReplies().clear();
                return;
            }
            case 7: {
                this.setDraft(false);
                return;
            }
            case 8: {
                this.getLocations().clear();
                return;
            }
            case 10: {
                this.setTitle(TITLE_EDEFAULT);
                return;
            }
            case 11: {
                this.setItem(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getIndex() != 0L;
            }
            case 1: {
                return CREATION_DATE_EDEFAULT == null ? this.creationDate != null : !CREATION_DATE_EDEFAULT.equals(this.creationDate);
            }
            case 2: {
                return MODIFICATION_DATE_EDEFAULT == null ? this.modificationDate != null : !MODIFICATION_DATE_EDEFAULT.equals(this.modificationDate);
            }
            case 3: {
                return this.author != null;
            }
            case 4: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 5: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 6: {
                return this.replies != null && !this.replies.isEmpty();
            }
            case 7: {
                return this.draft;
            }
            case 8: {
                return this.locations != null && !this.locations.isEmpty();
            }
            case 9: {
                return this.review != null;
            }
            case 10: {
                return TITLE_EDEFAULT == null ? this.title != null : !TITLE_EDEFAULT.equals(this.title);
            }
            case 11: {
                return this.basicGetItem() != null;
            }
            case 12: {
                return this.isMine();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IDated.class) {
            return switch (derivedFeatureID) {
                case 1 -> 0;
                case 2 -> 1;
                default -> -1;
            };
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IDated.class) {
            return switch (baseFeatureID) {
                case 0 -> 1;
                case 1 -> 2;
                default -> -1;
            };
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (creationDate: ");
        result.append(this.creationDate);
        result.append(", modificationDate: ");
        result.append(this.modificationDate);
        result.append(", description: ");
        result.append(this.description);
        result.append(", id: ");
        result.append(this.id);
        result.append(", draft: ");
        result.append(this.draft);
        result.append(", title: ");
        result.append(this.title);
        result.append(')');
        return result.toString();
    }
}

